/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.oss.ossEasyAPI.api.BHttpCookie;
import com.oss.ossEasyAPI.utils.BajaUtils;
import java.util.LinkedList;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
public class BHttpResponseCookies
extends BComponent {
    public static final Type TYPE = Sys.loadType(BHttpResponseCookies.class);
    private final LinkedList<String> slotsAdded = new LinkedList();

    public Type getType() {
        return TYPE;
    }

    public void clear() {
        this.slotsAdded.clear();
    }

    public void addCookie(List<String> cookieEntryList) {
        for (String cookieEntry : cookieEntryList) {
            BValue cookieObject;
            String[] segmentPair;
            String[] cookieSegments = cookieEntry.split(";");
            if (cookieSegments.length <= 0 || (segmentPair = this.extractPair(cookieSegments[0])) == null) continue;
            String cookieName = BajaUtils.sanitiseSlotName(segmentPair[0]);
            Property cookieSlot = this.getProperty(cookieName);
            if (cookieSlot == null) {
                cookieSlot = this.add(cookieName, (BValue)new BHttpCookie(), 1);
            }
            if (!((cookieObject = this.get(cookieSlot)) instanceof BHttpCookie)) {
                this.remove(cookieName);
                cookieSlot = this.add(cookieName, (BValue)new BHttpCookie(), 1);
                cookieObject = this.get(cookieSlot);
            }
            BHttpCookie currentCookie = (BHttpCookie)cookieObject;
            currentCookie.setCookieValue(segmentPair[1]);
            this.addCookieAttributes(currentCookie, cookieSegments);
            this.slotsAdded.add(cookieName);
        }
    }

    public void addCookieAttributes(BHttpCookie parentCookie, String[] cookieSegments) {
        BFolder attributesFolder;
        BValue attributesObject;
        LinkedList<String> attributesAdded = null;
        if (cookieSegments.length > 1) {
            Property attributeSlot = parentCookie.getProperty("attributes");
            if (attributeSlot == null) {
                attributeSlot = parentCookie.add("attributes", (BValue)new BFolder(), 1);
            }
            if (!((attributesObject = parentCookie.get(attributeSlot)) instanceof BFolder)) {
                parentCookie.remove("attributes");
                attributeSlot = parentCookie.add("attributes", (BValue)new BFolder(), 1);
                attributesObject = parentCookie.get(attributeSlot);
            }
            attributesFolder = (BFolder)attributesObject;
            attributesAdded = new LinkedList<String>();
            for (int attributeIndex = 1; attributeIndex < cookieSegments.length; ++attributeIndex) {
                String[] segmentPair = this.extractPair(cookieSegments[attributeIndex].trim());
                String attributeName = BajaUtils.sanitiseSlotName(segmentPair[0]);
                BString slotValue = BString.make((String)segmentPair[1]);
                attributeSlot = attributesFolder.getProperty(attributeName);
                if (attributeSlot == null) {
                    attributeSlot = attributesFolder.add(attributeName, (BValue)slotValue, 1);
                } else {
                    attributesFolder.set(attributeSlot, (BValue)slotValue);
                    attributesFolder.setFlags((Slot)attributeSlot, 1);
                }
                attributesFolder.setFacets((Slot)attributeSlot, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
                attributesAdded.add(attributeName);
            }
        }
        if ((attributesObject = parentCookie.get("attributes")) instanceof BFolder) {
            attributesFolder = (BFolder)attributesObject;
            for (Property prop : attributesFolder.getDynamicPropertiesArray()) {
                if (attributesAdded != null && attributesAdded.contains(prop.getName()) || !(attributesFolder.get(prop) instanceof BString)) continue;
                attributesFolder.remove(prop);
            }
        }
    }

    public String[] extractPair(String segmentPairStr) {
        int assignmentIndex = segmentPairStr.indexOf("=");
        if (assignmentIndex > 0) {
            return new String[]{segmentPairStr.substring(0, assignmentIndex).trim(), segmentPairStr.substring(assignmentIndex + 1).trim()};
        }
        return new String[]{segmentPairStr.trim(), "true"};
    }

    public void removeOldSlots() {
        for (Property prop : this.getDynamicPropertiesArray()) {
            if (this.slotsAdded.contains(prop.getName()) || !(this.get(prop) instanceof BHttpCookie)) continue;
            this.remove(prop);
        }
    }
}

