/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.oss.ossEasyAPI.api.BHttpRequestCookies;
import com.oss.ossEasyAPI.utils.BajaUtils;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="header", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)"), @Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="httpCookies", type="BHttpRequestCookies", defaultValue="new BHttpRequestCookies()", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="addHeaderEntry", parameterType="BString", defaultValue="BString.make(\"\")"), @NiagaraAction(name="removeHeaderEntry", parameterType="BString", defaultValue="BString.make(\"\")"), @NiagaraAction(name="update")})
public class BHttpRequestHeader
extends BComponent {
    public static final Property header = BHttpRequestHeader.newProperty((int)1, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60))));
    public static final Property httpCookies = BHttpRequestHeader.newProperty((int)1, (BValue)new BHttpRequestCookies(), null);
    public static final Action addHeaderEntry = BHttpRequestHeader.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action removeHeaderEntry = BHttpRequestHeader.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action update = BHttpRequestHeader.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BHttpRequestHeader.class);
    private boolean entriesGenerated = false;
    private final HashMap<String, String> headerEntries = new HashMap();

    public String getHeader() {
        return this.getString(header);
    }

    public void setHeader(String v) {
        this.setString(header, v, null);
    }

    public BHttpRequestCookies getHttpCookies() {
        return (BHttpRequestCookies)this.get(httpCookies);
    }

    public void setHttpCookies(BHttpRequestCookies v) {
        this.set(httpCookies, (BValue)v, null);
    }

    public void addHeaderEntry(BString parameter) {
        this.invoke(addHeaderEntry, (BValue)parameter, null);
    }

    public void removeHeaderEntry(BString parameter) {
        this.invoke(removeHeaderEntry, (BValue)parameter, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == header) {
            return;
        }
        this.generateHeader();
    }

    public void doUpdate() {
        this.generateHeader();
    }

    public void doAddHeaderEntry(BString headerName) {
        String slotName = BajaUtils.sanitiseSlotName(headerName.getString());
        Property newSlot = this.add(slotName, (BValue)BString.make((String)""));
        this.setFacets((Slot)newSlot, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
        this.generateHeader();
    }

    public void doRemoveHeaderEntry(BString headerName) {
        String slotName = BajaUtils.sanitiseSlotName(headerName.getString());
        for (Property child : this.getPropertiesArray()) {
            if (child == header || !slotName.equalsIgnoreCase(child.getName())) continue;
            this.remove(child);
        }
        this.generateHeader();
    }

    public void generateHeader() {
        StringBuilder headerText = new StringBuilder();
        this.headerEntries.clear();
        for (Property child : this.getDynamicPropertiesArray()) {
            if (child == header || !child.getType().is(BString.TYPE)) continue;
            String headerEntryName = this.getDisplayName((Slot)child, null);
            String headerEntryValue = this.get(child).toString().replace("\n", "").replace("\r", "");
            this.headerEntries.put(headerEntryName, headerEntryValue);
            headerText.append(headerEntryName);
            headerText.append(": ");
            headerText.append(headerEntryValue);
            headerText.append("\n");
        }
        String cookieHeader = this.getHttpCookies().getCookieHeader();
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            this.headerEntries.put("Cookie", cookieHeader);
            headerText.append("Cookie: ");
            headerText.append(cookieHeader);
            headerText.append("\n");
        }
        this.setHeader(headerText.toString());
        this.entriesGenerated = true;
    }

    public HashMap<String, String> getHeaderList() {
        if (!this.entriesGenerated) {
            this.generateHeader();
        }
        return this.headerEntries;
    }
}

