/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.oss.ossEasyAPI.utils.BajaUtils;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addCookie", parameterType="BString", defaultValue="BString.make(\"\")"), @NiagaraAction(name="removeCookie", parameterType="BString", defaultValue="BString.make(\"\")"), @NiagaraAction(name="update", flags=4)})
public class BHttpRequestCookies
extends BComponent {
    public static final Action addCookie = BHttpRequestCookies.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action removeCookie = BHttpRequestCookies.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action update = BHttpRequestCookies.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BHttpRequestCookies.class);
    private boolean cookieHeaderUpdated = false;
    private String cookieHeaderValue = null;

    public void addCookie(BString parameter) {
        this.invoke(addCookie, (BValue)parameter, null);
    }

    public void removeCookie(BString parameter) {
        this.invoke(removeCookie, (BValue)parameter, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.updateCookies();
    }

    public void doUpdate() {
        this.updateCookies();
    }

    public void doAddCookie(BString headerName) {
        String slotName = BajaUtils.sanitiseSlotName(headerName.getString());
        Property newSlot = this.add(slotName, (BValue)BString.make((String)""));
        this.setFacets((Slot)newSlot, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
        this.updateCookies();
    }

    public void doRemoveCookie(BString headerName) {
        String slotName = BajaUtils.sanitiseSlotName(headerName.getString());
        for (Property child : this.getPropertiesArray()) {
            if (!slotName.equalsIgnoreCase(child.getName())) continue;
            this.remove(child);
        }
        this.updateCookies();
    }

    public void updateCookies() {
        StringBuilder cookieBuilder = new StringBuilder();
        boolean notFirstCookie = false;
        for (Property child : this.getDynamicPropertiesArray()) {
            if (!child.getType().is(BString.TYPE)) continue;
            if (notFirstCookie) {
                cookieBuilder.append("; ");
            }
            cookieBuilder.append(this.getDisplayName((Slot)child, null));
            cookieBuilder.append("=");
            cookieBuilder.append(this.get(child).toString());
            notFirstCookie = true;
        }
        this.cookieHeaderValue = cookieBuilder.toString();
        this.cookieHeaderUpdated = true;
    }

    public String getCookieHeader() {
        if (!this.cookieHeaderUpdated) {
            this.updateCookies();
        }
        return this.cookieHeaderValue;
    }
}

