/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.oss.ossEasyAPI.api.ApiRequestProcessor;
import com.oss.ossEasyAPI.api.BOssEasyApiRequest;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.util.Random;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;

public class ApiRequestTask
extends Thread {
    private final BOssEasyApiRequest master;
    private volatile boolean abortTask = false;
    public static final int MINIMUM_UPDATE_PERIOD = 1000;
    private static final Logger log = OssEasyApiLog.getLog();

    public ApiRequestTask(BOssEasyApiRequest newRequestComponent) {
        this.master = newRequestComponent;
        this.setName("OSS-ApiRequestTask-" + this.master.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            this.master.dbgMsg("Request task started");
            this.abortTask = false;
            ApiRequestProcessor processor = new ApiRequestProcessor(this.master);
            boolean debugEnabled = this.master.getDebugEnabled();
            try {
                Random randGen = new Random(System.currentTimeMillis() + this.getId());
                ApiRequestTask apiRequestTask = this;
                synchronized (apiRequestTask) {
                    this.wait(randGen.nextInt(this.master.getStartupDelayMax()) + 10);
                }
                long lastRequestTime = System.currentTimeMillis() - this.master.getUpdatePeriod().getMillis();
                while (!this.abortTask) {
                    try {
                        if (this.master.getAutomaticUpdate()) {
                            long waitPeriod = lastRequestTime + this.master.getUpdatePeriod().getMillis() - System.currentTimeMillis();
                            if (waitPeriod < 1000L) {
                                waitPeriod = 1000L;
                            }
                            this.master.dbgMsg("Next request @ " + BAbsTime.make((long)(System.currentTimeMillis() + waitPeriod)));
                            apiRequestTask = this;
                            synchronized (apiRequestTask) {
                                this.wait(waitPeriod);
                            }
                        }
                        this.master.dbgMsg("Request task paused");
                        apiRequestTask = this;
                        synchronized (apiRequestTask) {
                            this.wait();
                        }
                        debugEnabled = this.master.getDebugEnabled();
                        String logIdent = "[" + this.master.getName() + "] ";
                        lastRequestTime = System.currentTimeMillis();
                        try {
                            processor.sendRequest();
                        }
                        catch (Exception requestException) {
                            log.severe(logIdent + "Request exception: " + requestException);
                            requestException.printStackTrace();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (InterruptedException randGen) {
            }
            catch (Exception requestException) {
                this.master.setFault("Request exception: " + requestException);
                if (!debugEnabled) break block19;
                requestException.printStackTrace();
            }
        }
        this.master.dbgMsg("Request task terminated");
    }

    public void abort() {
        this.abortTask = true;
        this.interrupt();
    }
}

