/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.oss.ossEasyAPI.alarm.BStaleAlarmExt;
import com.oss.ossEasyAPI.api.BOssEasyApiRequest;
import com.oss.ossEasyAPI.license.OssEasyApiLicense;
import com.oss.ossEasyAPI.processing.DataTreeGenerator;
import com.oss.ossEasyAPI.processing.XmlProcessor;
import com.oss.ossEasyAPI.request.HttpBasicAuth;
import com.oss.ossEasyAPI.request.HttpRequest;
import java.util.HashMap;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BString;

public class ApiRequestProcessor {
    private final BOssEasyApiRequest master;

    public ApiRequestProcessor(BOssEasyApiRequest newRequestComponent) {
        this.master = newRequestComponent;
    }

    public void sendRequest() {
        if (!OssEasyApiLicense.isLicensed()) {
            this.master.setFault("ossEasyAPI is not licensed");
            return;
        }
        if (this.master.getApiUrl().isEmpty()) {
            this.master.setResponseCode(0);
            this.master.setFault("API URL is not set");
            return;
        }
        HashMap<String, String> headerFields = this.master.getHttpHeader().getHeaderList();
        if (this.master.getAuthorisation().isBasic()) {
            headerFields.put("Authorization", "Basic " + HttpBasicAuth.encode(this.master.getCredentials()));
        } else if (this.master.getAuthorisation().isToken()) {
            headerFields.put("Authorization", "Bearer " + this.master.getBearerToken());
        }
        String writeBody = null;
        if (this.master.getHttpMethod().hasWriteData()) {
            writeBody = this.master.getHttpBody();
        }
        HttpRequest request = new HttpRequest(this.master.getApiUrl(), this.master.getHttpMethod().getTag().toUpperCase(), headerFields, writeBody, this.master.getConnectTimeout(), this.master.getReadTimeout(), this.master.getMaxResponseSize());
        request.setRemoveNewlines(this.master.getRemoveLineEnds());
        request.setDebugEnabled(this.master.getDebugEnabled());
        request.setDebugIdent(this.master.getName());
        this.master.setCurrentState("Request in progress");
        request.sendRequest();
        int responseCode = request.getResponseCode();
        this.master.setResponseCode(responseCode);
        if (responseCode >= 300 && responseCode < 400 && request.getRedirectLocation() != null) {
            request.setApiUrl(request.getRedirectLocation());
            this.master.dbgMsg("Redirecting to " + request.getRedirectLocation());
            request.sendRequest();
            this.master.setResponseCode(request.getResponseCode());
        }
        if (request.getRequestSuccess()) {
            this.processSuccess(request);
        } else {
            this.processFailure(request);
        }
    }

    public void processSuccess(HttpRequest request) {
        BStaleAlarmExt[] alarms;
        this.master.setResponseError("");
        this.master.setResponseBody(request.getResponseBody());
        this.processResponse(request.getResponseBody());
        this.master.getResponseHeader().process(request.getResponseHeaders());
        this.master.setRequestSuccess(true);
        this.master.clearFault();
        BAbsTime requestTime = BAbsTime.make((long)request.getRequestTime());
        this.master.setLastRequestSuccess(requestTime);
        this.master.setCurrentState("Request success @ " + requestTime);
        this.master.fireSuccessTrigger(BBoolean.TRUE);
        if (!this.master.getResponseJson().isEmpty()) {
            this.master.fireRouteJson(BString.make((String)this.master.getResponseJson()));
        }
        if ((alarms = (BStaleAlarmExt[])this.master.getChildren(BStaleAlarmExt.class)) != null && alarms.length > 0) {
            alarms[0].requestSuccess();
        }
    }

    public void processFailure(HttpRequest request) {
        this.master.setResponseError(request.getResponseError());
        this.master.setFault(request.getFaultMessage());
        this.master.fireFailureTrigger(BBoolean.TRUE);
    }

    public void processResponse(String responseBody) {
        String xmlJson;
        if (responseBody == null || responseBody.isEmpty()) {
            if (this.master.getClearOutputOnFault()) {
                this.master.setResponseJson("");
            }
            return;
        }
        Gson gson = new Gson();
        JsonElement inputJson = null;
        try {
            inputJson = gson.fromJson(responseBody, JsonElement.class);
            if (!inputJson.isJsonObject() && !inputJson.isJsonArray()) {
                inputJson = null;
            }
        }
        catch (Exception jsonException) {
            this.master.dbgMsg("Response is not JSON");
        }
        if (inputJson == null && (xmlJson = XmlProcessor.processXmlToJson(responseBody)) != null && !(xmlJson = xmlJson.trim()).isEmpty() && !xmlJson.equals("{}")) {
            try {
                inputJson = gson.fromJson(xmlJson, JsonElement.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (inputJson != null) {
                this.master.setResponseJson(inputJson.toString().trim());
                if (this.master.getGenerateDataTree()) {
                    DataTreeGenerator.generate(this.master, inputJson);
                }
            } else {
                this.master.dbgMsg("Response not valid JSON");
                this.master.setResponseError("Response not valid JSON");
                if (this.master.getClearOutputOnFault()) {
                    this.master.setResponseJson("");
                }
            }
        }
        catch (Exception jsonException) {
            jsonException.printStackTrace();
        }
    }
}

