/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.api;

import com.oss.ossEasyAPI.api.ApiRequestProcessor;
import com.oss.ossEasyAPI.api.BOssEasyApiRequest;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ApiRequestPool
extends Thread {
    private final BOssEasyApiRequest master;
    private static ThreadPoolExecutor pool = null;
    private static final int POOL_CORE_SIZE = 10;
    private static final int POOL_MAX_SIZE = 25000;
    private static final int TASK_KEEP_ALIVE_TIME = 100;

    public ApiRequestPool(BOssEasyApiRequest newRequestComponent) {
        this.master = newRequestComponent;
        this.setName("OSS-ApiRequestThread-" + this.master.getName());
    }

    @Override
    public void run() {
        this.master.dbgMsg("Request thread started");
        ApiRequestProcessor processor = new ApiRequestProcessor(this.master);
        try {
            processor.sendRequest();
        }
        catch (Exception requestException) {
            requestException.printStackTrace();
        }
        this.master.dbgMsg("Request thread terminated");
    }

    public static synchronized boolean execute(BOssEasyApiRequest requestComponent) {
        boolean taskDispatched = false;
        if (pool == null) {
            pool = new ThreadPoolExecutor(10, 25000, 100L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        try {
            pool.execute(new ApiRequestPool(requestComponent));
            taskDispatched = true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return taskDispatched;
    }
}

