/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.alarm;

import com.oss.ossEasyAPI.api.BOssEasyApiRequest;
import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make( \"alarm:AlarmClassFE\" )")}), @NiagaraProperty(name="alarmSourceName", type="BFormat", defaultValue="BFormat.make( \"%parent.displayName%/%displayName%\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="toFaultMessage", type="BFormat", defaultValue="BFormat.make( \"Fault: API stale timeout\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="toNormalMessage", type="BFormat", defaultValue="BFormat.DEFAULT", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="currentAlarmState", type="BSourceState", defaultValue="BSourceState.normal", flags=1), @NiagaraProperty(name="lastAlarmTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastSuccessTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="nextTimeout", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="staleTimeout", type="BRelTime", defaultValue="BRelTime.makeHours( 3 )"), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="signalSuccess"), @NiagaraAction(name="sendAlarm"), @NiagaraAction(name="toNormal"), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=5)})
public class BStaleAlarmExt
extends BComponent
implements BIAlarmSource {
    public static final Property alarmEnabled = BStaleAlarmExt.newProperty((int)0, (boolean)false, null);
    public static final Property alarmClass = BStaleAlarmExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property alarmSourceName = BStaleAlarmExt.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%/%displayName%"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property toFaultMessage = BStaleAlarmExt.newProperty((int)0, (BValue)BFormat.make((String)"Fault: API stale timeout"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property toNormalMessage = BStaleAlarmExt.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property currentAlarmState = BStaleAlarmExt.newProperty((int)1, (BValue)BSourceState.normal, null);
    public static final Property lastAlarmTime = BStaleAlarmExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastSuccessTime = BStaleAlarmExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property nextTimeout = BStaleAlarmExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property staleTimeout = BStaleAlarmExt.newProperty((int)0, (BValue)BRelTime.makeHours((int)3), null);
    public static final Property debugEnabled = BStaleAlarmExt.newProperty((int)4, (boolean)false, null);
    public static final Action signalSuccess = BStaleAlarmExt.newAction((int)0, null);
    public static final Action sendAlarm = BStaleAlarmExt.newAction((int)0, null);
    public static final Action toNormal = BStaleAlarmExt.newAction((int)0, null);
    public static final Action ackAlarm = BStaleAlarmExt.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BStaleAlarmExt.class);
    private BComponent sourceObject = null;
    private String logPrefix = "";
    private Clock.Ticket staleTimer = null;
    private int currentFaultCount = 0;
    private final AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    private static final Logger log = OssEasyApiLog.getLog();

    public boolean getAlarmEnabled() {
        return this.getBoolean(alarmEnabled);
    }

    public void setAlarmEnabled(boolean v) {
        this.setBoolean(alarmEnabled, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BFormat getAlarmSourceName() {
        return (BFormat)this.get(alarmSourceName);
    }

    public void setAlarmSourceName(BFormat v) {
        this.set(alarmSourceName, (BValue)v, null);
    }

    public BFormat getToFaultMessage() {
        return (BFormat)this.get(toFaultMessage);
    }

    public void setToFaultMessage(BFormat v) {
        this.set(toFaultMessage, (BValue)v, null);
    }

    public BFormat getToNormalMessage() {
        return (BFormat)this.get(toNormalMessage);
    }

    public void setToNormalMessage(BFormat v) {
        this.set(toNormalMessage, (BValue)v, null);
    }

    public BSourceState getCurrentAlarmState() {
        return (BSourceState)this.get(currentAlarmState);
    }

    public void setCurrentAlarmState(BSourceState v) {
        this.set(currentAlarmState, (BValue)v, null);
    }

    public BAbsTime getLastAlarmTime() {
        return (BAbsTime)this.get(lastAlarmTime);
    }

    public void setLastAlarmTime(BAbsTime v) {
        this.set(lastAlarmTime, (BValue)v, null);
    }

    public BAbsTime getLastSuccessTime() {
        return (BAbsTime)this.get(lastSuccessTime);
    }

    public void setLastSuccessTime(BAbsTime v) {
        this.set(lastSuccessTime, (BValue)v, null);
    }

    public BAbsTime getNextTimeout() {
        return (BAbsTime)this.get(nextTimeout);
    }

    public void setNextTimeout(BAbsTime v) {
        this.set(nextTimeout, (BValue)v, null);
    }

    public BRelTime getStaleTimeout() {
        return (BRelTime)this.get(staleTimeout);
    }

    public void setStaleTimeout(BRelTime v) {
        this.set(staleTimeout, (BValue)v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void signalSuccess() {
        this.invoke(signalSuccess, null, null);
    }

    public void sendAlarm() {
        this.invoke(sendAlarm, null, null);
    }

    public void toNormal() {
        this.invoke(toNormal, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.sourceObject = null;
        BComplex parentObject = this.getParent();
        if (!(parentObject instanceof BOssEasyApiRequest)) {
            log.severe("StaleAlarmExt parent must be OssEasyApiRequest");
            throw new BajaRuntimeException("Invalid parent type");
        }
        this.sourceObject = (BComponent)this.getParent();
        this.logPrefix = "[" + this.sourceObject.getName() + "] ";
        this.staleTimerStart();
    }

    public void stopped() {
        this.staleTimerStop();
    }

    public void changed(Property prop, Context cxt) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == alarmEnabled) {
            if (this.getAlarmEnabled()) {
                this.staleTimerStart();
            } else {
                this.staleTimerStop();
            }
        }
        if (prop == staleTimeout) {
            this.staleTimerStart();
        }
    }

    public void doSignalSuccess() {
        this.dbgMsg("Signal success");
        this.requestSuccess();
    }

    public void doSendAlarm() {
        this.dbgMsg("Send alarm");
        this.dispatchAlarm(BSourceState.fault);
    }

    public void doToNormal() {
        this.dispatchAlarm(BSourceState.normal);
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        try {
            this.alarmSupport.ackAlarm(ackRequest);
        }
        catch (Exception alarmException) {
            alarmException.printStackTrace();
        }
        return BBoolean.TRUE;
    }

    public final void dispatchAlarm(BSourceState alarmState) {
        if (this.getAlarmEnabled() && this.sourceObject != null && alarmState != this.getCurrentAlarmState()) {
            try {
                BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                if (alarmService != null) {
                    BAlarmClass alarmClassInstance = alarmService.lookupAlarmClass(this.getAlarmClass());
                    if (alarmClassInstance != null) {
                        this.alarmSupport.setAlarmClass(this.getAlarmClass());
                        boolean alarmToNormal = alarmState.getOrdinal() == 0;
                        this.sourceObject = (BComponent)this.getParent();
                        String sourcePathText = this.getAlarmSourceName().format((Object)this.sourceObject);
                        HashMap<String, Object> alarmFacets = new HashMap<String, Object>();
                        alarmFacets.put("sourceName", BString.make((String)sourcePathText));
                        alarmFacets.put("presentValue", BString.make((String)alarmState.getTag()));
                        alarmFacets.put("fromState", BString.make((String)this.getCurrentAlarmState().getTag()));
                        alarmFacets.put("toState", BString.make((String)alarmState.getTag()));
                        this.setCurrentAlarmState(alarmState);
                        if (alarmToNormal) {
                            this.currentFaultCount = 0;
                            String messageText = this.getToNormalMessage().format((Object)this.sourceObject).trim();
                            if (!messageText.isEmpty()) {
                                alarmFacets.put("msgText", BString.make((String)messageText));
                            }
                            this.alarmSupport.toNormal(BFacets.make(alarmFacets), null);
                            if (this.getDebugEnabled()) {
                                log.fine(this.logPrefix + "Alarm Normal [" + sourcePathText + "]");
                            }
                        } else {
                            this.setLastAlarmTime(BAbsTime.now());
                            String messageText = this.getToFaultMessage().format((Object)this.sourceObject).trim();
                            if (!messageText.isEmpty()) {
                                alarmFacets.put("msgText", BString.make((String)messageText));
                            }
                            ++this.currentFaultCount;
                            alarmFacets.put("Count", BInteger.make((int)this.currentFaultCount));
                            this.alarmSupport.newFaultAlarm(BFacets.make(alarmFacets));
                            if (this.getDebugEnabled()) {
                                log.warning(this.logPrefix + "Alarm Fault [" + sourcePathText + "]: " + messageText);
                            }
                        }
                    } else {
                        log.warning(this.logPrefix + "Invalid alarm class: " + this.getAlarmClass());
                    }
                }
            }
            catch (Exception alarmException) {
                alarmException.printStackTrace();
            }
        }
    }

    public void staleTimerStart() {
        this.dbgMsg("staleTimerStart");
        if (this.getAlarmEnabled()) {
            if (this.staleTimer != null) {
                this.staleTimer.cancel();
            }
            if (this.getStaleTimeout().getMillis() > 0L) {
                BAbsTime scheduleTime = BAbsTime.now().add(this.getStaleTimeout());
                this.staleTimer = Clock.schedule((BComponent)this, (BAbsTime)scheduleTime, (Action)sendAlarm, null);
                this.dbgMsg("Schedule timeout for " + scheduleTime);
                this.setNextTimeout(scheduleTime);
            }
        } else {
            this.dbgMsg("Alarm disabled");
        }
    }

    public void staleTimerStop() {
        this.dbgMsg("staleTimerStop");
        if (this.staleTimer != null) {
            this.staleTimer.cancel();
        }
        this.setNextTimeout(BAbsTime.NULL);
    }

    public void requestSuccess() {
        this.dbgMsg("Request success");
        this.staleTimerStart();
        this.dispatchAlarm(BSourceState.normal);
        this.setLastSuccessTime(BAbsTime.now());
    }

    public void dbgMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.finest(this.logPrefix + debugMessage);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyAPI/icons/gear-icon.png");
    }
}

