/*
 * Decompiled with CFR 0.152.
 */
package com.oss.ossEasyAPI.alarm;

import com.oss.ossEasyAPI.log.OssEasyApiLog;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make( \"alarm:AlarmClassFE\" )")}), @NiagaraProperty(name="alarmSourceName", type="BFormat", defaultValue="BFormat.make( \"%parent.displayName%/%displayName%\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="toFaultMessage", type="BFormat", defaultValue="BFormat.make( \"Fault: %faultCause%\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="toNormalMessage", type="BFormat", defaultValue="BFormat.DEFAULT", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(50)")}), @NiagaraProperty(name="lastAlarmTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="toNormal"), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=5)})
public class BApiAlarm
extends BComponent
implements BIAlarmSource {
    public static final Property alarmEnabled = BApiAlarm.newProperty((int)0, (boolean)false, null);
    public static final Property alarmClass = BApiAlarm.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property alarmSourceName = BApiAlarm.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%/%displayName%"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property toFaultMessage = BApiAlarm.newProperty((int)0, (BValue)BFormat.make((String)"Fault: %faultCause%"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property toNormalMessage = BApiAlarm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)50)));
    public static final Property lastAlarmTime = BApiAlarm.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property debugEnabled = BApiAlarm.newProperty((int)4, (boolean)false, null);
    public static final Action toNormal = BApiAlarm.newAction((int)0, null);
    public static final Action ackAlarm = BApiAlarm.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BApiAlarm.class);
    private BSourceState lastState = null;
    private int currentFaultCount = 0;
    private final AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    private static final Logger log = OssEasyApiLog.getLog();

    public boolean getAlarmEnabled() {
        return this.getBoolean(alarmEnabled);
    }

    public void setAlarmEnabled(boolean v) {
        this.setBoolean(alarmEnabled, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BFormat getAlarmSourceName() {
        return (BFormat)this.get(alarmSourceName);
    }

    public void setAlarmSourceName(BFormat v) {
        this.set(alarmSourceName, (BValue)v, null);
    }

    public BFormat getToFaultMessage() {
        return (BFormat)this.get(toFaultMessage);
    }

    public void setToFaultMessage(BFormat v) {
        this.set(toFaultMessage, (BValue)v, null);
    }

    public BFormat getToNormalMessage() {
        return (BFormat)this.get(toNormalMessage);
    }

    public void setToNormalMessage(BFormat v) {
        this.set(toNormalMessage, (BValue)v, null);
    }

    public BAbsTime getLastAlarmTime() {
        return (BAbsTime)this.get(lastAlarmTime);
    }

    public void setLastAlarmTime(BAbsTime v) {
        this.set(lastAlarmTime, (BValue)v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void toNormal() {
        this.invoke(toNormal, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void dispatch(BSourceState alarmState) {
        if (this.getAlarmEnabled() && (alarmState != this.lastState || this.lastState == null)) {
            try {
                BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                if (alarmService != null) {
                    BAlarmClass alarmClassInstance = alarmService.lookupAlarmClass(this.getAlarmClass());
                    if (alarmClassInstance != null) {
                        this.alarmSupport.setAlarmClass(this.getAlarmClass());
                        boolean alarmToNormal = alarmState.getOrdinal() == 0;
                        BComponent sourceObject = (BComponent)this.getParent();
                        String sourcePathText = this.getAlarmSourceName().format((Object)sourceObject);
                        HashMap<String, Object> alarmFacets = new HashMap<String, Object>();
                        alarmFacets.put("sourceName", BString.make((String)sourcePathText));
                        alarmFacets.put("presentValue", BString.make((String)alarmState.getTag()));
                        if (this.lastState != null) {
                            alarmFacets.put("fromState", BString.make((String)this.lastState.getTag()));
                        } else {
                            alarmFacets.put("fromState", BString.make((String)BSourceState.normal.getTag()));
                        }
                        alarmFacets.put("toState", BString.make((String)alarmState.getTag()));
                        if (alarmToNormal) {
                            this.currentFaultCount = 0;
                            String messageText = this.getToNormalMessage().format((Object)sourceObject).trim();
                            if (!messageText.isEmpty()) {
                                alarmFacets.put("msgText", BString.make((String)messageText));
                            }
                            this.alarmSupport.toNormal(BFacets.make(alarmFacets), null);
                            if (this.getDebugEnabled()) {
                                log.fine("Alarm Normal [" + sourcePathText + "]");
                            }
                        } else {
                            String messageText = this.getToFaultMessage().format((Object)sourceObject).trim();
                            if (!messageText.isEmpty()) {
                                alarmFacets.put("msgText", BString.make((String)messageText));
                            }
                            ++this.currentFaultCount;
                            alarmFacets.put("Count", BInteger.make((int)this.currentFaultCount));
                            this.alarmSupport.newFaultAlarm(BFacets.make(alarmFacets));
                            this.setLastAlarmTime(BAbsTime.now());
                            if (this.getDebugEnabled()) {
                                log.warning("Alarm Fault [" + sourcePathText + "]: " + messageText);
                            }
                        }
                        this.lastState = alarmState;
                    } else {
                        log.warning("Invalid alarm class: " + this.getAlarmClass());
                    }
                }
            }
            catch (Exception alarmException) {
                alarmException.printStackTrace();
            }
        }
    }

    public void doToNormal() {
        this.dispatch(BSourceState.normal);
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        try {
            this.alarmSupport.ackAlarm(ackRequest);
        }
        catch (Exception alarmException) {
            alarmException.printStackTrace();
        }
        return BBoolean.TRUE;
    }
}

