/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.webhook.servlet;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import solutions.onesight.ossChirpManager.license.OssChirpManagerLicense;
import solutions.onesight.ossChirpManager.log.OssModuleLog;
import solutions.onesight.ossChirpManager.manager.BOssChirpstackDeviceManager;
import solutions.onesight.ossChirpManager.webhook.service.BOssChirpstackWebhookService;
import solutions.onesight.ossChirpManager.webhook.servlet.ServletUtils;

public class ServletRequest {
    public static final String RESPONSE_DATA = "{\"success\":true}";
    public static final String RESPONSE_TYPE = "application/json";
    public static final String REQUEST_TYPE = "application/json";

    public static void processRequest(HttpServletRequest request, HttpServletResponse response) {
        BOssChirpstackWebhookService service = null;
        try {
            service = (BOssChirpstackWebhookService)Sys.getService((Type)BOssChirpstackWebhookService.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (service == null) {
            OssModuleLog.debug("OssWebhookService not found");
            ServletUtils.failureResponse(response, 400, "OssWebhookService not found");
            return;
        }
        if (!OssChirpManagerLicense.isLicensed()) {
            OssModuleLog.debug("ossChirpManager is not licensed");
            ServletUtils.failureResponse(response, 400, "ossChirpManager is not licensed");
            return;
        }
        if (!service.getStatus().isOk()) {
            service.debugMsg("OssWebhookService fault: " + service.getFaultCause());
            ServletUtils.failureResponse(response, 400, "OssWebhookService fault");
            return;
        }
        if (!service.getEnabled()) {
            service.debugMsg("OssWebhookService disabled");
            ServletUtils.failureResponse(response, 400, "OssWebhookService disabled");
            return;
        }
        String endpointPath = ServletUtils.getEndpointPath(request);
        service.debugMsg("Endpoint path: " + endpointPath);
        if (!endpointPath.equalsIgnoreCase(service.getEndpointPath().trim())) {
            service.debugMsg("Invalid endpoint path: " + endpointPath);
            ServletUtils.failureResponse(response, 404, "Invalid endpoint path");
            return;
        }
        String postData = ServletUtils.getRequestBody(request, service.getMaxPostSize());
        if (service.getAuthentication().checkAuth(request)) {
            if (request.getContentType().equalsIgnoreCase("application/json")) {
                service.setPayloadData(postData);
                ServletUtils.successResponse(response, "application/json", RESPONSE_DATA);
                service.setLastUpdate(BAbsTime.now());
                service.fireReceivedPayload(BBoolean.TRUE);
                for (BOssChirpstackDeviceManager manager : (BOssChirpstackDeviceManager[])service.getChildren(BOssChirpstackDeviceManager.class)) {
                    manager.setJsonInput(postData);
                }
                if (service.getLogPayloads()) {
                    service.debugMsg("Payload[" + postData.length() + "]: " + postData);
                }
            } else {
                service.debugMsg("Invalid request type");
                ServletUtils.failureResponse(response, 415, "Invalid request type");
            }
        } else {
            service.debugMsg("Request auth failed");
            ServletUtils.failureResponse(response, 401, "Unauthorized");
        }
    }
}

