/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.webhook.service;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.http.HttpServletRequest;
import solutions.onesight.ossChirpManager.log.OssModuleLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="keyName", type="String", defaultValue="new String( \"X-Api-Key\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(80)")}), @NiagaraProperty(name="keyValue", type="String", defaultValue="tjvaPGXHQQqhf8PaPIKgQbNp", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(80)")}), @NiagaraProperty(name="enableExpiry", type="boolean", defaultValue="false"), @NiagaraProperty(name="expiry", type="BAbsTime", defaultValue="BAbsTime.make( 2050, BMonth.january, 1 )")})
public final class BAuthApiKey
extends BComponent {
    public static final Property enabled = BAuthApiKey.newProperty((int)0, (boolean)false, null);
    public static final Property keyName = BAuthApiKey.newProperty((int)0, (String)new String("X-Api-Key"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)80)));
    public static final Property keyValue = BAuthApiKey.newProperty((int)0, (String)"tjvaPGXHQQqhf8PaPIKgQbNp", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)80)));
    public static final Property enableExpiry = BAuthApiKey.newProperty((int)0, (boolean)false, null);
    public static final Property expiry = BAuthApiKey.newProperty((int)0, (BValue)BAbsTime.make((int)2050, (BMonth)BMonth.january, (int)1), null);
    public static final Type TYPE = Sys.loadType(BAuthApiKey.class);

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getKeyName() {
        return this.getString(keyName);
    }

    public void setKeyName(String v) {
        this.setString(keyName, v, null);
    }

    public String getKeyValue() {
        return this.getString(keyValue);
    }

    public void setKeyValue(String v) {
        this.setString(keyValue, v, null);
    }

    public boolean getEnableExpiry() {
        return this.getBoolean(enableExpiry);
    }

    public void setEnableExpiry(boolean v) {
        this.setBoolean(enableExpiry, v, null);
    }

    public BAbsTime getExpiry() {
        return (BAbsTime)this.get(expiry);
    }

    public void setExpiry(BAbsTime v) {
        this.set(expiry, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean checkAuth(HttpServletRequest request) {
        boolean validAuth;
        block8: {
            validAuth = false;
            if (this.getEnabled()) {
                try {
                    String apiKeyName = this.getKeyName().trim();
                    if (!apiKeyName.isEmpty()) {
                        if (this.getExpiry().isAfter(BAbsTime.now())) {
                            String authHeader = request.getHeader(apiKeyName);
                            if (authHeader != null) {
                                validAuth = authHeader.trim().equalsIgnoreCase(this.getKeyValue().trim());
                            }
                        } else {
                            OssModuleLog.debug("Auth [" + this.getName() + "] expired");
                        }
                        break block8;
                    }
                    OssModuleLog.error("Auth [" + this.getName() + "] empty key name");
                }
                catch (Exception authException) {
                    OssModuleLog.debug("AuthApiKey exception: " + authException);
                }
            } else {
                validAuth = true;
            }
        }
        return validAuth;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"securityHigh.png");
    }
}

