/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtils {
    public static String toIsoUtc(long epochMilliseconds) {
        return TimeUtils.toIsoUtc(new Date(epochMilliseconds));
    }

    public static String toIsoUtc(Calendar srcTime) {
        return TimeUtils.toIsoUtc(srcTime.getTime());
    }

    public static String toIsoUtc(Date srcTime) {
        String timeStr = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            timeStr = simpleDateFormat.format(srcTime);
        }
        catch (Exception timeException) {
            timeException.printStackTrace();
        }
        return timeStr;
    }

    public static String toIsoTimezone(long epochMilliseconds) {
        return TimeUtils.toIsoTimezone(new Date(epochMilliseconds));
    }

    public static String toIsoTimezone(Calendar srcTime) {
        return TimeUtils.toIsoTimezone(srcTime.getTime());
    }

    public static String toIsoTimezone(Date srcTime) {
        String timeStr = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            timeStr = simpleDateFormat.format(srcTime);
        }
        catch (Exception timeException) {
            timeException.printStackTrace();
        }
        return timeStr;
    }

    public static String toRFC2822(long epochMilliseconds) {
        return TimeUtils.toRFC2822(new Date(epochMilliseconds));
    }

    public static String toRFC2822(Calendar srcTime) {
        return TimeUtils.toRFC2822(srcTime.getTime());
    }

    public static String toRFC2822(Date srcTime) {
        String timeStr = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            timeStr = simpleDateFormat.format(srcTime);
        }
        catch (Exception timeException) {
            timeException.printStackTrace();
        }
        return timeStr;
    }

    public static String toTimestamp(long epochMilliseconds) {
        return TimeUtils.toTimestamp(new Date(epochMilliseconds));
    }

    public static String toTimestamp(Calendar srcTime) {
        return TimeUtils.toTimestamp(srcTime.getTime());
    }

    public static String toTimestamp(Date srcTime) {
        String timeStr = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            timeStr = simpleDateFormat.format(srcTime);
        }
        catch (Exception timeException) {
            timeException.printStackTrace();
        }
        return timeStr;
    }

    public static String toHuman(long epochMilliseconds) {
        return TimeUtils.toHuman(new Date(epochMilliseconds));
    }

    public static String toHuman(Calendar srcTime) {
        return TimeUtils.toHuman(srcTime.getTime());
    }

    public static String toHuman(Date srcTime) {
        String timeStr = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss zzz");
            timeStr = simpleDateFormat.format(srcTime);
        }
        catch (Exception timeException) {
            timeException.printStackTrace();
        }
        return timeStr;
    }

    public static String toBasic(long epochMilliseconds) {
        return TimeUtils.toBasic(new Date(epochMilliseconds));
    }

    public static String toBasic(Calendar srcTime) {
        return TimeUtils.toBasic(srcTime.getTime());
    }

    public static String toBasic(Date srcTime) {
        String timeStr = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyy HH:mm");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            timeStr = simpleDateFormat.format(srcTime);
        }
        catch (Exception timeException) {
            timeException.printStackTrace();
        }
        return timeStr;
    }
}

