/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.utils;

import java.text.NumberFormat;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BString;

public class StrUtils {
    public static String byteToBinary(byte byteValue) {
        return StrUtils.byteToBinary(0xFF & byteValue);
    }

    public static String byteToBinary(int byteValue) {
        String paddedResult = "0000000000" + Integer.toBinaryString(byteValue);
        return paddedResult.substring(paddedResult.length() - 8);
    }

    public static String dataToHex(byte[] data) {
        return StrUtils.dataToHex(data, "/");
    }

    public static String dataToHex(byte[] data, String seperator) {
        String hexStr = "";
        if (data != null) {
            for (int byteIndex = 0; byteIndex < data.length; ++byteIndex) {
                if (byteIndex != 0) {
                    hexStr = hexStr + seperator;
                }
                hexStr = hexStr + StrUtils.paddedHex(0xFF & data[byteIndex], 2);
            }
        } else {
            hexStr = "null";
        }
        return hexStr;
    }

    public static String paddedHex(int value) {
        return StrUtils.paddedHex((byte)value, 2);
    }

    public static String paddedHex(byte value) {
        return StrUtils.paddedHex(value, 2);
    }

    public static String paddedHex(long value, int numDigits) {
        return StrUtils.paddedStr(Long.toHexString(value).toUpperCase(), numDigits);
    }

    public static String paddedHex(int value, int numDigits) {
        return StrUtils.paddedStr(Integer.toHexString(value).toUpperCase(), numDigits);
    }

    public static String paddedStr(String originalText, int numDigits) {
        String paddedResult = "0000000000" + originalText;
        return paddedResult.substring(paddedResult.length() - numDigits, paddedResult.length());
    }

    public static String numberFormat2(double value) {
        NumberFormat logFormat = NumberFormat.getInstance();
        logFormat.setMaximumFractionDigits(2);
        return logFormat.format(value);
    }

    public static String sanitiseSlotName(BString originalSlotName) {
        String tmpSlotName;
        String newSlotName = null;
        if (originalSlotName != null && !(tmpSlotName = originalSlotName.getString().trim()).isEmpty()) {
            newSlotName = SlotPath.escape((String)tmpSlotName);
        }
        return newSlotName;
    }
}

