/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.utils;

import java.io.File;
import java.io.FileWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import solutions.onesight.ossChirpManager.utils.TimeUtils;

public class FileUtils {
    public static String getFilePath(String path) {
        if (path.startsWith("file:^")) {
            return Sys.getStationHome().toString() + "/" + path.substring(6);
        }
        if (path.startsWith("local:|file:^")) {
            return Sys.getStationHome().toString() + "/" + path.substring(13);
        }
        if (path.startsWith("local:|foxs:|file:^")) {
            return Sys.getStationHome().toString() + "/" + path.substring(19);
        }
        if (path.startsWith("file:/")) {
            return path.substring(6);
        }
        if (path.startsWith("local:|file:/")) {
            return path.substring(13);
        }
        return null;
    }

    public static String getFilePath(BOrd ord) {
        return FileUtils.getFilePath(ord.encodeToString());
    }

    public static File getFile(String path) {
        String filePath = FileUtils.getFilePath(path);
        if (filePath != null) {
            return new File(filePath);
        }
        return null;
    }

    public static String makeTimeStampFilename(String remotePath) {
        String timestamp = TimeUtils.toTimestamp(System.currentTimeMillis());
        int extIndex = remotePath.lastIndexOf(".");
        String newPath = extIndex > 0 ? remotePath.substring(0, extIndex) + "-" + timestamp + remotePath.substring(extIndex) : remotePath + "-" + timestamp;
        return newPath;
    }

    public static boolean writeFile(String filePath, String contents) {
        boolean writeSuccess = false;
        try {
            FileWriter outputWriter = new FileWriter(filePath);
            outputWriter.write(contents);
            outputWriter.close();
            writeSuccess = true;
        }
        catch (Exception writeException) {
            writeException.printStackTrace();
        }
        return writeSuccess;
    }

    public static File getFile(BOrd ord) {
        return FileUtils.getFile(ord.encodeToString());
    }
}

