/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.manager;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.baja.alarm.BSourceState;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.util.BFolder;
import solutions.onesight.ossChirpManager.device.BOssChirpstackDevice;
import solutions.onesight.ossChirpManager.log.OssModuleLog;
import solutions.onesight.ossChirpManager.manager.BOssChirpstackDeviceManager;

public class DeviceCheckTask {
    private ScheduledFuture<?> scheduleHandle = null;
    private BAbsTime startTime = BAbsTime.now();
    private final BOssChirpstackDeviceManager master;
    private static final ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(3);

    public DeviceCheckTask(BOssChirpstackDeviceManager newMaster) {
        this.master = newMaster;
    }

    public void startSchedule() {
        if (this.master.getEnabled() && this.scheduleHandle == null) {
            try {
                this.startTime = BAbsTime.now();
                this.scheduleHandle = threadPoolExecutor.scheduleAtFixedRate(new CheckThread(), this.master.getDeviceCheckPeriod(), this.master.getDeviceCheckPeriod(), TimeUnit.MINUTES);
            }
            catch (Exception ignore) {
                this.scheduleHandle = null;
            }
        }
    }

    public void cancelSchedule() {
        this.scheduleHandle.cancel(true);
        this.scheduleHandle = null;
    }

    private class CheckThread
    extends Thread {
        private CheckThread() {
        }

        @Override
        public void run() {
            if (DeviceCheckTask.this.master.getDebugEnabled()) {
                OssModuleLog.debug("Checking devices [" + DeviceCheckTask.this.master.getSlotPath().getBody() + "]");
            }
            try {
                this.checkFolder(DeviceCheckTask.this.master.getDevices());
            }
            catch (Exception checkException) {
                DeviceCheckTask.this.master.errorMsg("Device check failed: " + checkException);
            }
            if (DeviceCheckTask.this.master.getDebugEnabled()) {
                OssModuleLog.debug("Device check complete [" + DeviceCheckTask.this.master.getSlotPath().getBody() + "]");
            }
        }

        private void checkFolder(BFolder deviceParent) {
            for (BOssChirpstackDevice bOssChirpstackDevice : (BOssChirpstackDevice[])deviceParent.getChildren(BOssChirpstackDevice.class)) {
                this.checkDevice(bOssChirpstackDevice);
            }
            for (BOssChirpstackDevice bOssChirpstackDevice : (BFolder[])deviceParent.getChildren(BFolder.class)) {
                this.checkFolder((BFolder)bOssChirpstackDevice);
            }
        }

        private void checkDevice(BOssChirpstackDevice currentDevice) {
            if (currentDevice.getEnabled() && currentDevice.getDeviceConfig().getEnableStaleAlarm() && !currentDevice.getStatus().isStale()) {
                BAbsTime staleTime = BAbsTime.now().subtract(BRelTime.makeMinutes((int)currentDevice.getDeviceConfig().getStaleAlarmPeriod()));
                if (DeviceCheckTask.this.startTime.isBefore(staleTime) && currentDevice.getLastUpdate().isBefore(staleTime)) {
                    currentDevice.setStatus(BStatus.makeStale((BStatus)currentDevice.getStatus(), (boolean)true));
                    currentDevice.setFaultCause("Device stale");
                    OssModuleLog.getLog().warning("[" + currentDevice.getDevEUI() + "] Device stale");
                    DeviceCheckTask.this.master.getDeviceAlarm().dispatch(currentDevice, BSourceState.fault);
                    if (currentDevice.getDebugEnabled()) {
                        OssModuleLog.debug("Device [" + currentDevice.getSlotPath().getBody() + "] Stale alarm");
                    }
                }
            }
        }
    }
}

