/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.manager;

import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import solutions.onesight.ossChirpManager.decode.DecodeTask;
import solutions.onesight.ossChirpManager.decode.OssDigestMaster;
import solutions.onesight.ossChirpManager.decode.PayloadData;
import solutions.onesight.ossChirpManager.device.BDeviceConfig;
import solutions.onesight.ossChirpManager.device.BOssChirpstackDevice;
import solutions.onesight.ossChirpManager.license.OssChirpManagerLicense;
import solutions.onesight.ossChirpManager.log.OssModuleLog;
import solutions.onesight.ossChirpManager.manager.BDeviceAlarm;
import solutions.onesight.ossChirpManager.manager.BDeviceFolder;
import solutions.onesight.ossChirpManager.manager.BDeviceHistory;
import solutions.onesight.ossChirpManager.manager.DeviceCheckTask;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="jsonInput", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="slotName", type="BFormat", defaultValue="BFormat.make( \"device_%devEUI%\" )", flags=4, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="deviceConfig", type="BDeviceConfig", defaultValue="new BDeviceConfig()"), @NiagaraProperty(name="historyConfig", type="BDeviceHistory", defaultValue="new BDeviceHistory()"), @NiagaraProperty(name="deviceAlarm", type="BDeviceAlarm", defaultValue="new BDeviceAlarm()"), @NiagaraProperty(name="devices", type="BDeviceFolder", defaultValue="new BDeviceFolder()"), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=9, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="deviceCheckPeriod", type="int", defaultValue="15", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"minute\" )")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
public class BOssChirpstackDeviceManager
extends BComponent
implements OssDigestMaster {
    public static final Property enabled = BOssChirpstackDeviceManager.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssChirpstackDeviceManager.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssChirpstackDeviceManager.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property jsonInput = BOssChirpstackDeviceManager.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property slotName = BOssChirpstackDeviceManager.newProperty((int)4, (BValue)BFormat.make((String)"device_%devEUI%"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property deviceConfig = BOssChirpstackDeviceManager.newProperty((int)0, (BValue)new BDeviceConfig(), null);
    public static final Property historyConfig = BOssChirpstackDeviceManager.newProperty((int)0, (BValue)new BDeviceHistory(), null);
    public static final Property deviceAlarm = BOssChirpstackDeviceManager.newProperty((int)0, (BValue)new BDeviceAlarm(), null);
    public static final Property devices = BOssChirpstackDeviceManager.newProperty((int)0, (BValue)new BDeviceFolder(), null);
    public static final Property lastUpdate = BOssChirpstackDeviceManager.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property deviceCheckPeriod = BOssChirpstackDeviceManager.newProperty((int)4, (int)15, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"minute")));
    public static final Property debugEnabled = BOssChirpstackDeviceManager.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BOssChirpstackDeviceManager.class);
    private final DeviceCheckTask deviceChecker = new DeviceCheckTask(this);

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getJsonInput() {
        return this.getString(jsonInput);
    }

    public void setJsonInput(String v) {
        this.setString(jsonInput, v, null);
    }

    public BFormat getSlotName() {
        return (BFormat)this.get(slotName);
    }

    public void setSlotName(BFormat v) {
        this.set(slotName, (BValue)v, null);
    }

    public BDeviceConfig getDeviceConfig() {
        return (BDeviceConfig)this.get(deviceConfig);
    }

    public void setDeviceConfig(BDeviceConfig v) {
        this.set(deviceConfig, (BValue)v, null);
    }

    public BDeviceHistory getHistoryConfig() {
        return (BDeviceHistory)this.get(historyConfig);
    }

    public void setHistoryConfig(BDeviceHistory v) {
        this.set(historyConfig, (BValue)v, null);
    }

    public BDeviceAlarm getDeviceAlarm() {
        return (BDeviceAlarm)this.get(deviceAlarm);
    }

    public void setDeviceAlarm(BDeviceAlarm v) {
        this.set(deviceAlarm, (BValue)v, null);
    }

    public BDeviceFolder getDevices() {
        return (BDeviceFolder)this.get(devices);
    }

    public void setDevices(BDeviceFolder v) {
        this.set(devices, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public int getDeviceCheckPeriod() {
        return this.getInt(deviceCheckPeriod);
    }

    public void setDeviceCheckPeriod(int v) {
        this.setInt(deviceCheckPeriod, v, null);
    }

    @Override
    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssChirpManagerLicense.checkLicense()) {
            this.setFault("ossChirpManager is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
            this.deviceChecker.startSchedule();
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
                this.deviceChecker.startSchedule();
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.deviceChecker.cancelSchedule();
            }
        } else if (property == deviceCheckPeriod) {
            if (this.getEnabled()) {
                this.deviceChecker.startSchedule();
            }
        } else if (property == jsonInput) {
            this.update(this.getJsonInput());
        }
    }

    private void update(String updateData) {
        if (!OssChirpManagerLicense.isLicensed()) {
            this.setFault("ossChirpManager is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            return;
        }
        if (updateData.isEmpty() || updateData.equals("-")) {
            return;
        }
        DecodeTask updateTask = new DecodeTask(this, updateData, this.getDeviceConfig().getUniqueIdentifierField());
        updateTask.start();
    }

    @Override
    public void processDevice(PayloadData payloadData) {
        BOssChirpstackDevice deviceNode = this.getDevices().findDevice(payloadData.devEUI);
        if (deviceNode == null) {
            deviceNode = new BOssChirpstackDevice(payloadData.devEUI);
            deviceNode.setFlags((Slot)BOssChirpstackDevice.jsonIn, 5);
            deviceNode.getDeviceConfig().setKeyIgnoreList(this.getDeviceConfig().getKeyIgnoreList());
            deviceNode.getDeviceConfig().setPinDecodeSlots(this.getDeviceConfig().getPinDecodeSlots());
            deviceNode.getDeviceConfig().setRemoveOldSlots(this.getDeviceConfig().getRemoveOldSlots());
            deviceNode.getDeviceConfig().setStaleAlarmPeriod(this.getDeviceConfig().getStaleAlarmPeriod());
            deviceNode.getDeviceConfig().setUniqueIdentifierField(this.getDeviceConfig().getUniqueIdentifierField());
            deviceNode.getDeviceConfig().setFlattenPayloadStructure(this.getDeviceConfig().getFlattenPayloadStructure());
            deviceNode.getDeviceConfig().setFieldDecodeType(this.getDeviceConfig().getFieldDecodeType());
            deviceNode.getDeviceConfig().setFlags((Slot)BDeviceConfig.uniqueIdentifierField, 5);
            deviceNode.getDeviceConfig().setFlags((Slot)BDeviceConfig.flattenPayloadStructure, 5);
            deviceNode.getDeviceConfig().setFlags((Slot)BDeviceConfig.fieldDecodeType, 5);
            deviceNode.getDeviceConfig().setFlags((Slot)BDeviceConfig.enableStaleAlarm, 0);
            deviceNode.getDeviceConfig().setFlags((Slot)BDeviceConfig.staleAlarmPeriod, 0);
            deviceNode.getDeviceHistory().setEnableAutoHistoryExtensions(this.getHistoryConfig().getEnableAutoHistoryExtensions());
            deviceNode.getDeviceHistory().setIntervalHistoryFieldNames(this.getHistoryConfig().getIntervalHistoryFieldNames());
            deviceNode.getDeviceHistory().setCovHistoryFieldNames(this.getHistoryConfig().getCovHistoryFieldNames());
            deviceNode.getDeviceHistory().setDefaultInterval(this.getHistoryConfig().getDefaultInterval());
            deviceNode.setFlags((Slot)BOssChirpstackDevice.deviceHistory, 4);
            deviceNode.update(payloadData);
            String slotName = SlotPath.escape((String)this.getSlotName().format((Object)deviceNode));
            if (this.getDevices().get(slotName) == null) {
                this.getDevices().add(slotName, (BValue)deviceNode);
            } else {
                OssModuleLog.getLog().warning("[" + this.getName() + "] Node already exists: " + slotName);
            }
        } else {
            deviceNode.update(payloadData);
        }
        this.clearFault();
        this.setLastUpdate(BAbsTime.now());
    }

    public static BOssChirpstackDeviceManager findManager(BComponent currentNode) {
        BOssChirpstackDeviceManager foundManager = null;
        try {
            BComplex searchNode = currentNode.getParent();
            while (searchNode instanceof BDeviceFolder || searchNode instanceof BOssChirpstackDeviceManager) {
                if (searchNode instanceof BOssChirpstackDeviceManager) {
                    foundManager = (BOssChirpstackDeviceManager)searchNode;
                    break;
                }
                searchNode = searchNode.getParent();
            }
        }
        catch (Exception searchException) {
            OssModuleLog.getLog().severe("DeviceDigesterManager search exception: " + searchException);
        }
        return foundManager;
    }

    public void clearFault() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    @Override
    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        this.errorMsg(faultMessage);
    }

    @Override
    public void errorMsg(String errorText) {
        OssModuleLog.getLog().severe("[" + this.getName() + "] " + errorText);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossChirpManager/icons/oss-icon-16.png");
    }
}

