/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.manager;

import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import solutions.onesight.ossChirpManager.device.BOssChirpstackDevice;
import solutions.onesight.ossChirpManager.utils.StrUtils;

@NiagaraType
@NiagaraAction(name="addSubfolder", parameterType="BString", defaultValue="BString.make(\"folder\")")
public class BDeviceFolder
extends BFolder {
    public static final Action addSubfolder = BDeviceFolder.newAction((int)0, (BValue)BString.make((String)"folder"), null);
    public static final Type TYPE = Sys.loadType(BDeviceFolder.class);

    public void addSubfolder(BString parameter) {
        this.invoke(addSubfolder, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doAddSubfolder(BString newFolderName) {
        String folderName = StrUtils.sanitiseSlotName(newFolderName);
        if (folderName != null) {
            this.add(newFolderName + "?", (BValue)new BDeviceFolder());
        }
    }

    public BOssChirpstackDevice findDevice(String devEUI) {
        return this.findDevice(this, devEUI);
    }

    public BOssChirpstackDevice findDevice(BFolder deviceParent, String devEUI) {
        BOssChirpstackDevice foundDevice = null;
        for (BOssChirpstackDevice currentDevice : (BOssChirpstackDevice[])deviceParent.getChildren(BOssChirpstackDevice.class)) {
            if (!currentDevice.getDevEUI().equalsIgnoreCase(devEUI)) continue;
            foundDevice = currentDevice;
            break;
        }
        if (foundDevice == null) {
            BDeviceFolder childFolder;
            BDeviceFolder[] bDeviceFolderArray = (BDeviceFolder[])deviceParent.getChildren(BDeviceFolder.class);
            int n = bDeviceFolderArray.length;
            for (int i = 0; i < n && (foundDevice = this.findDevice(childFolder = bDeviceFolderArray[i], devEUI)) == null; ++i) {
            }
        }
        return foundDevice;
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossChirpManager/icons/oss-folder.png");
    }
}

