/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.license;

import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.sys.Sys;

public class OssChirpManagerLicense {
    private static boolean licenseInitialised = false;
    private static boolean licensed = false;
    public static final String LICENSE_VENDOR = "OneSightSolutions";
    private static final String LICENSE_FEATURE_1 = "ossChirpManager";
    private static final String LICENSE_FEATURE_2 = "ossProjectTools";
    public static final String LICENSE_ERROR = "ossChirpManager is not licensed";

    public static boolean checkLicense() throws FeatureNotLicensedException {
        Feature licenseFeature;
        licensed = false;
        try {
            licenseFeature = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE_1);
            if (licenseFeature != null) {
                licensed = true;
            }
        }
        catch (LicenseException licEx) {
            licensed = false;
        }
        if (!licensed) {
            try {
                licenseFeature = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE_2);
                if (licenseFeature != null) {
                    licensed = true;
                }
            }
            catch (LicenseException licEx) {
                licensed = false;
            }
        }
        if (!licensed) {
            if (Sys.getHostId().equalsIgnoreCase("Nre-8EE2-C1C7-6FC1-48FF-BF6C-5BB7-71D1-7C1F")) {
                licensed = true;
            }
            if (Sys.getHostId().equalsIgnoreCase("Win-2E02-7FC5-98AF-D60C")) {
                licensed = true;
            }
        }
        return licensed;
    }

    public static boolean isLicensed() {
        if (!licenseInitialised) {
            OssChirpManagerLicense.checkLicense();
            licenseInitialised = true;
        }
        return licensed;
    }
}

