/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.device;

import com.google.gson.JsonObject;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import solutions.onesight.ossChirpManager.decode.GenericPointDecoder;
import solutions.onesight.ossChirpManager.device.BDeviceConfig;
import solutions.onesight.ossChirpManager.manager.BDeviceHistory;
import solutions.onesight.ossChirpManager.utils.StrUtils;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addNumericSlot", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="addBooleanSlot", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="addStringSlot", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="deleteDecodeSlots")})
public class BPointsFolder
extends BFolder {
    public static final Action addNumericSlot = BPointsFolder.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action addBooleanSlot = BPointsFolder.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action addStringSlot = BPointsFolder.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action deleteDecodeSlots = BPointsFolder.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPointsFolder.class);

    public void addNumericSlot(BString parameter) {
        this.invoke(addNumericSlot, (BValue)parameter, null);
    }

    public void addBooleanSlot(BString parameter) {
        this.invoke(addBooleanSlot, (BValue)parameter, null);
    }

    public void addStringSlot(BString parameter) {
        this.invoke(addStringSlot, (BValue)parameter, null);
    }

    public void deleteDecodeSlots() {
        this.invoke(deleteDecodeSlots, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doAddNumericSlot(BString newSlotName) {
        this.addSlot(newSlotName, (BValue)BDouble.DEFAULT);
    }

    public void doAddBooleanSlot(BString newSlotName) {
        this.addSlot(newSlotName, (BValue)BBoolean.DEFAULT);
    }

    public void doAddStringSlot(BString newSlotName) {
        this.addSlot(newSlotName, (BValue)BString.DEFAULT);
    }

    public void doDeleteDecodeSlots() {
        for (Property prop : this.getDynamicPropertiesArray()) {
            BValue slot = this.get(prop);
            if (!(slot instanceof BDouble) && !(slot instanceof BBoolean) && !(slot instanceof BString)) continue;
            this.remove(prop);
        }
    }

    public void update(BDeviceConfig config, BDeviceHistory hConfig, JsonObject dataElement, boolean isChirpstackData) {
        GenericPointDecoder.processPoints((BComponent)this, config, hConfig, dataElement);
    }

    public void addSlot(BString newSlotName, BValue newSlotValue) {
        String slotName = StrUtils.sanitiseSlotName(newSlotName);
        if (slotName != null) {
            this.add(newSlotName + "?", newSlotValue, 65);
        }
    }

    public BIcon getIcon() {
        return BIcon.std((String)"pointFolder.png");
    }
}

