/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.device;

import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import solutions.onesight.ossChirpManager.decode.DecodeTask;
import solutions.onesight.ossChirpManager.decode.OssDigestMaster;
import solutions.onesight.ossChirpManager.decode.PayloadData;
import solutions.onesight.ossChirpManager.device.BDeviceConfig;
import solutions.onesight.ossChirpManager.device.BPointsFolder;
import solutions.onesight.ossChirpManager.license.OssChirpManagerLicense;
import solutions.onesight.ossChirpManager.log.OssModuleLog;
import solutions.onesight.ossChirpManager.manager.BDeviceHistory;
import solutions.onesight.ossChirpManager.manager.BOssChirpstackDeviceManager;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="jsonIn", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="devEUI", type="String", defaultValue="", flags=73, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)")}), @NiagaraProperty(name="deviceName", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="deviceConfig", type="BDeviceConfig", defaultValue="new BDeviceConfig()"), @NiagaraProperty(name="deviceHistory", type="BDeviceHistory", defaultValue="new BDeviceHistory()"), @NiagaraProperty(name="points", type="BPointsFolder", defaultValue="new BPointsFolder()"), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=73, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="changeDevEui", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="duplicateDevice")})
@NiagaraTopic(name="deviceUpdated", eventType="BBoolean")
public class BOssChirpstackDevice
extends BComponent
implements OssDigestMaster {
    public static final Property enabled = BOssChirpstackDevice.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssChirpstackDevice.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssChirpstackDevice.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property jsonIn = BOssChirpstackDevice.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property devEUI = BOssChirpstackDevice.newProperty((int)73, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)));
    public static final Property deviceName = BOssChirpstackDevice.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property deviceConfig = BOssChirpstackDevice.newProperty((int)0, (BValue)new BDeviceConfig(), null);
    public static final Property deviceHistory = BOssChirpstackDevice.newProperty((int)0, (BValue)new BDeviceHistory(), null);
    public static final Property points = BOssChirpstackDevice.newProperty((int)0, (BValue)new BPointsFolder(), null);
    public static final Property lastUpdate = BOssChirpstackDevice.newProperty((int)73, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property debugEnabled = BOssChirpstackDevice.newProperty((int)4, (boolean)false, null);
    public static final Action changeDevEui = BOssChirpstackDevice.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action duplicateDevice = BOssChirpstackDevice.newAction((int)0, null);
    public static final Topic deviceUpdated = BOssChirpstackDevice.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssChirpstackDevice.class);

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getJsonIn() {
        return this.getString(jsonIn);
    }

    public void setJsonIn(String v) {
        this.setString(jsonIn, v, null);
    }

    public String getDevEUI() {
        return this.getString(devEUI);
    }

    public void setDevEUI(String v) {
        this.setString(devEUI, v, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    public BDeviceConfig getDeviceConfig() {
        return (BDeviceConfig)this.get(deviceConfig);
    }

    public void setDeviceConfig(BDeviceConfig v) {
        this.set(deviceConfig, (BValue)v, null);
    }

    public BDeviceHistory getDeviceHistory() {
        return (BDeviceHistory)this.get(deviceHistory);
    }

    public void setDeviceHistory(BDeviceHistory v) {
        this.set(deviceHistory, (BValue)v, null);
    }

    public BPointsFolder getPoints() {
        return (BPointsFolder)this.get(points);
    }

    public void setPoints(BPointsFolder v) {
        this.set(points, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Override
    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void changeDevEui(BString parameter) {
        this.invoke(changeDevEui, (BValue)parameter, null);
    }

    public void duplicateDevice() {
        this.invoke(duplicateDevice, null, null);
    }

    public void fireDeviceUpdated(BBoolean event) {
        this.fire(deviceUpdated, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOssChirpstackDevice() {
    }

    public BOssChirpstackDevice(String newDevEui) {
        this.setDevEUI(newDevEui);
    }

    public void started() {
        if (this.deviceIsManaged()) {
            this.getDeviceConfig().setFlags((Slot)BDeviceConfig.enableStaleAlarm, 0);
            this.getDeviceConfig().setFlags((Slot)BDeviceConfig.staleAlarmPeriod, 0);
        } else {
            this.getDeviceConfig().setFlags((Slot)BDeviceConfig.enableStaleAlarm, 4);
            this.getDeviceConfig().setFlags((Slot)BDeviceConfig.staleAlarmPeriod, 4);
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == jsonIn) {
            if (!this.getJsonIn().isEmpty()) {
                this.decodeJsonInput(this.getJsonIn());
            }
        } else if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void doChangeDevEui(BString newDevEui) {
        this.setDevEUI(newDevEui.getString().trim());
    }

    public void doDuplicateDevice() {
        BComplex parentObject = this.getParent();
        if (parentObject instanceof BComponent) {
            BComponent deviceParent = (BComponent)parentObject;
            deviceParent.add("device_duplicate1?", this.newCopy());
        }
    }

    private void decodeJsonInput(String updateData) {
        if (!OssChirpManagerLicense.isLicensed()) {
            this.setFault("ossChirpManager is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            return;
        }
        if (updateData.isEmpty() || updateData.equals("-")) {
            return;
        }
        DecodeTask updateTask = new DecodeTask(this, updateData, this.getDeviceConfig().getUniqueIdentifierField());
        updateTask.start();
    }

    @Override
    public void processDevice(PayloadData payloadData) {
        if (this.getDevEUI().isEmpty()) {
            this.setDevEUI(payloadData.devEUI);
            this.update(payloadData);
        } else if (payloadData.devEUI.equalsIgnoreCase(this.getDevEUI())) {
            this.update(payloadData);
        }
    }

    public void update(PayloadData payloadData) {
        if (this.getEnabled()) {
            if (this.getDebugEnabled()) {
                OssModuleLog.debug("Updating device: " + this.getSlotPath().getBody());
            }
            this.getPoints().update(this.getDeviceConfig(), this.getDeviceHistory(), payloadData.pointData, payloadData.isChirpstackData);
            this.clearFault();
            this.setLastUpdate(BAbsTime.now());
            this.fireDeviceUpdated(BBoolean.TRUE);
            if (payloadData.deviceName != null) {
                this.setDeviceName(payloadData.deviceName);
            }
        }
    }

    public void clearFault() {
        BOssChirpstackDeviceManager manager;
        boolean clearAlarm = !this.getStatus().isOk();
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        if (this.deviceIsManaged() && clearAlarm && (manager = BOssChirpstackDeviceManager.findManager(this)) != null) {
            manager.getDeviceAlarm().dispatch(this, BSourceState.normal);
            if (this.getDebugEnabled()) {
                OssModuleLog.debug("Device [" + this.getSlotPath().getBody() + "] Alarm normal");
            }
        }
    }

    @Override
    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        this.errorMsg(faultMessage);
    }

    @Override
    public void errorMsg(String errorText) {
        String logIdent = this.getDevEUI();
        if (logIdent.isEmpty()) {
            logIdent = this.getSlotPath().getBody();
        }
        OssModuleLog.getLog().severe("[" + logIdent + "] " + errorText);
    }

    public String toString(Context cxt) {
        if (this.getDeviceName().isEmpty()) {
            return this.getDevEUI();
        }
        return this.getDeviceName();
    }

    public boolean deviceIsManaged() {
        return (this.getFlags((Slot)jsonIn) & 4) != 0;
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossChirpManager/icons/oss-device.png");
    }
}

