/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.decode;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import solutions.onesight.ossChirpManager.decode.OssDigestMaster;
import solutions.onesight.ossChirpManager.decode.PayloadData;
import solutions.onesight.ossChirpManager.utils.JsonUtils;

public class PayloadDecoder {
    public static PayloadData getPayloadData(OssDigestMaster master, String payloadText, String uniqueId) {
        JsonElement payloadElement;
        try {
            payloadElement = JsonParser.parseString(payloadText);
        }
        catch (JsonSyntaxException jsonException) {
            master.setFault("Invalid JSON: " + jsonException.getMessage());
            return null;
        }
        catch (Exception jsonException) {
            master.setFault("Invalid JSON: " + jsonException);
            return null;
        }
        PayloadData payloadData = null;
        if (payloadElement.isJsonObject()) {
            JsonElement deviceInfoElement;
            JsonObject payloadObject = payloadElement.getAsJsonObject();
            JsonObject deviceInfoObject = null;
            if (payloadObject.has("deviceInfo") && (deviceInfoElement = payloadObject.get("deviceInfo")).isJsonObject()) {
                deviceInfoObject = deviceInfoElement.getAsJsonObject();
            }
            String devEui = null;
            if (payloadObject.has(uniqueId)) {
                devEui = JsonUtils.getString(payloadObject.get(uniqueId));
                if (devEui == null) {
                    devEui = JsonUtils.getNumber(payloadObject.get(uniqueId)).toString();
                }
            } else if (deviceInfoObject != null && deviceInfoObject.has(uniqueId)) {
                devEui = JsonUtils.getString(deviceInfoObject.get(uniqueId));
            }
            if (devEui == null) {
                master.errorMsg("Invalid JSON data: No " + uniqueId);
                return null;
            }
            String deviceName = null;
            deviceName = payloadObject.has("deviceName") ? JsonUtils.getString(payloadObject.get("deviceName")) : (deviceInfoObject != null && deviceInfoObject.has("deviceName") ? JsonUtils.getString(deviceInfoObject.get("deviceName")) : devEui.toLowerCase());
            payloadData = new PayloadData();
            payloadData.devEUI = devEui.toLowerCase();
            payloadData.pointData = payloadObject;
            payloadData.deviceName = deviceName;
        } else if (payloadElement.isJsonArray()) {
            master.setFault("JSON data invalid (array)");
        } else if (payloadElement.isJsonNull()) {
            master.setFault("JSON data invalid (null)");
        } else {
            master.setFault("JSON data invalid");
        }
        return payloadData;
    }
}

