/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.decode;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.history.ext.BBooleanCovHistoryExt;
import javax.baja.history.ext.BBooleanIntervalHistoryExt;
import javax.baja.history.ext.BCovHistoryExt;
import javax.baja.history.ext.BIntervalHistoryExt;
import javax.baja.history.ext.BNumericCovHistoryExt;
import javax.baja.history.ext.BNumericIntervalHistoryExt;
import javax.baja.history.ext.BStringCovHistoryExt;
import javax.baja.history.ext.BStringIntervalHistoryExt;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import solutions.onesight.ossChirpManager.device.BDeviceConfig;
import solutions.onesight.ossChirpManager.device.BFieldEnum;
import solutions.onesight.ossChirpManager.log.OssModuleLog;
import solutions.onesight.ossChirpManager.manager.BDeviceHistory;
import solutions.onesight.ossChirpManager.points.BJsonBoolean;
import solutions.onesight.ossChirpManager.points.BJsonNumeric;
import solutions.onesight.ossChirpManager.points.BJsonString;

public class GenericPointDecoder {
    public static void processPoints(BComponent slotParent, BDeviceConfig config, BDeviceHistory hConfig, JsonElement dataElement) {
        try {
            JsonObject dataObject = dataElement.getAsJsonObject();
            ArrayList<String> slotsAdded = new ArrayList<String>();
            List<String> ignoreList = Arrays.asList(config.getKeyIgnoreList().split(","));
            GenericPointDecoder.handleJsonObject(slotParent, config, hConfig, ignoreList, dataObject, slotsAdded, 2);
            if (config.getRemoveOldSlots()) {
                GenericPointDecoder.removeOldSlots(slotParent, slotsAdded);
            }
        }
        catch (Exception processException) {
            OssModuleLog.error("Points processing exception [" + slotParent.getSlotPath() + "]: " + processException.getMessage());
        }
    }

    private static BValue createNewValue(JsonElement dataElement) {
        BDouble newProperty = null;
        if (dataElement.isJsonPrimitive()) {
            JsonPrimitive dataPrimitive = dataElement.getAsJsonPrimitive();
            if (dataPrimitive.isNumber()) {
                newProperty = BDouble.make((double)dataPrimitive.getAsDouble());
            } else if (dataPrimitive.isBoolean()) {
                newProperty = BBoolean.make((boolean)dataPrimitive.getAsBoolean());
            } else if (dataPrimitive.isString()) {
                newProperty = BString.make((String)dataPrimitive.getAsString());
            }
        }
        return newProperty;
    }

    private static BComponent createNewComponent(JsonElement dataElement) {
        Object newProperty = null;
        if (dataElement.isJsonPrimitive()) {
            JsonPrimitive dataPrimitive = dataElement.getAsJsonPrimitive();
            if (dataPrimitive.isNumber()) {
                newProperty = new BJsonNumeric(dataPrimitive.getAsDouble());
            } else if (dataPrimitive.isBoolean()) {
                newProperty = new BJsonBoolean(dataElement.getAsBoolean());
            } else if (dataPrimitive.isString()) {
                newProperty = new BJsonString(dataElement.getAsString());
            }
        }
        return newProperty;
    }

    private static void removeOldSlots(BComponent slotParent, ArrayList<String> slotsAdded) {
        for (Property prop : slotParent.getDynamicPropertiesArray()) {
            if (prop.toString().contains("baja:Folder")) {
                GenericPointDecoder.removeOldSlots(slotParent.get(prop).asComponent(), slotsAdded);
            }
            if (slotsAdded.contains(prop.getName())) continue;
            System.out.println(prop.getName());
            BValue slot = slotParent.get(prop);
            if (!(slot instanceof BDouble) && !(slot instanceof BBoolean) && !(slot instanceof BString) && !(slot instanceof BJsonString) && !(slot instanceof BJsonBoolean) && !(slot instanceof BJsonNumeric)) continue;
            slotParent.remove(prop);
        }
    }

    private static void addJsonPrimitive(BComponent slotParent, BDeviceConfig config, BDeviceHistory hConfig, String name, JsonPrimitive primitive, ArrayList<String> slotsAdded, int level) {
        BComponent newComponent = null;
        BValue newValue = null;
        String slotName = SlotPath.escape((String)name);
        Property valueSlot = slotParent.getProperty(slotName);
        int slotFlags = 65;
        if (config.getFieldDecodeType().equals((Object)BFieldEnum.Slot)) {
            newValue = GenericPointDecoder.createNewValue(primitive);
        } else {
            newComponent = GenericPointDecoder.createNewComponent(primitive);
        }
        if (newValue != null || newComponent != null) {
            if (valueSlot == null) {
                if (newComponent != null) {
                    slotParent.add(slotName, (BValue)newComponent, slotFlags);
                    GenericPointDecoder.generateHistory(hConfig, newComponent, slotName, level);
                } else {
                    slotParent.add(slotName, newValue, slotFlags);
                }
            } else if (config.getFieldDecodeType().equals((Object)BFieldEnum.Component)) {
                BComponent[] children;
                for (BComponent child : children = slotParent.getChildComponents()) {
                    if (!child.getName().equals(slotName)) continue;
                    child.lease();
                    if (primitive.isNumber()) {
                        ((BJsonNumeric)child).assignValue(primitive.getAsDouble());
                    } else if (primitive.isBoolean()) {
                        ((BJsonBoolean)child).assignValue(primitive.getAsBoolean());
                    } else if (primitive.isString()) {
                        ((BJsonString)child).assignValue(primitive.getAsString());
                    } else {
                        OssModuleLog.error("Mismatched type: " + slotParent.getSlotPath().getBody() + "/" + slotName);
                    }
                    break;
                }
            } else if (valueSlot.getType().equals(newValue.getType())) {
                slotParent.set(valueSlot, newValue);
                slotParent.setFlags((Slot)valueSlot, slotFlags |= slotParent.getFlags((Slot)valueSlot));
            } else {
                OssModuleLog.error("Mismatched type: " + slotParent.getSlotPath().getBody() + "/" + slotName);
            }
            if (!slotsAdded.contains(slotName)) {
                slotsAdded.add(slotName);
            }
        } else {
            OssModuleLog.error("Invalid data type: " + slotParent.getSlotPath().getBody() + "/" + name);
        }
    }

    private static void generateHistory(BDeviceHistory hConfig, BComponent point, String slotName, int level) {
        BComponent[] childComponents = point.getChildComponents();
        String parent_name = "%";
        for (int i = 0; i < level; ++i) {
            parent_name = parent_name + "parent.";
        }
        parent_name = parent_name + "name%_%parent.name%";
        ArrayList<String> covNames = new ArrayList<String>(Arrays.asList(hConfig.getCovHistoryFieldNames().split(",")));
        ArrayList<String> intervalNames = new ArrayList<String>(Arrays.asList(hConfig.getIntervalHistoryFieldNames().split(",")));
        if (covNames.contains(slotName)) {
            BNumericCovHistoryExt ext = null;
            boolean exists = false;
            for (BComponent child : childComponents) {
                if (!(child instanceof BCovHistoryExt)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                if (point instanceof BJsonNumeric) {
                    ext = new BNumericCovHistoryExt();
                }
                if (point instanceof BJsonBoolean) {
                    ext = new BBooleanCovHistoryExt();
                }
                if (point instanceof BJsonString) {
                    ext = new BStringCovHistoryExt();
                }
                if (ext != null) {
                    ext.setHistoryName(BFormat.make((String)parent_name));
                    point.add("CovHistory", (BValue)ext);
                    ext.setEnabled(true);
                }
            }
        } else if (intervalNames.contains(slotName)) {
            BNumericIntervalHistoryExt ext = null;
            boolean exists = false;
            for (BComponent child : childComponents) {
                if (!(child instanceof BIntervalHistoryExt)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                if (point instanceof BJsonNumeric) {
                    ext = new BNumericIntervalHistoryExt();
                }
                if (point instanceof BJsonBoolean) {
                    ext = new BBooleanIntervalHistoryExt();
                }
                if (point instanceof BJsonString) {
                    ext = new BStringIntervalHistoryExt();
                }
                if (ext != null) {
                    ext.setInterval(hConfig.getDefaultInterval());
                    ext.setHistoryName(BFormat.make((String)parent_name));
                    point.add("IntervalHistory", (BValue)ext);
                    ext.setEnabled(true);
                }
            }
        }
    }

    private static void handleJsonObject(BComponent slotParent, BDeviceConfig config, BDeviceHistory hConfig, List<String> ignoreList, JsonObject obj, ArrayList<String> slotsAdded, int level) {
        Object[] keySet = obj.keySet().toArray(new String[0]);
        Arrays.sort(keySet);
        for (Object entryKey : keySet) {
            BValue childNode;
            if (ignoreList.contains(entryKey)) continue;
            JsonElement element = obj.get((String)entryKey);
            if (element.isJsonPrimitive()) {
                GenericPointDecoder.addJsonPrimitive(slotParent, config, hConfig, (String)entryKey, element.getAsJsonPrimitive(), slotsAdded, level + 1);
                continue;
            }
            if (element.isJsonObject()) {
                if (!config.getFlattenPayloadStructure()) {
                    childNode = slotParent.get((String)entryKey);
                    BFolder objectFolder = new BFolder();
                    if (childNode instanceof BFolder) {
                        objectFolder = (BFolder)childNode;
                        slotsAdded.add((String)entryKey);
                    } else {
                        slotParent.add((String)entryKey, (BValue)objectFolder);
                        slotsAdded.add((String)entryKey);
                    }
                    GenericPointDecoder.handleJsonObject((BComponent)objectFolder, config, hConfig, ignoreList, element.getAsJsonObject(), slotsAdded, level + 1);
                    continue;
                }
                GenericPointDecoder.handleJsonObject(slotParent, config, hConfig, ignoreList, element.getAsJsonObject(), slotsAdded, level + 1);
                continue;
            }
            if (!element.isJsonArray()) continue;
            if (!config.getFlattenPayloadStructure()) {
                childNode = slotParent.get((String)entryKey);
                BFolder arrayFolder = new BFolder();
                if (childNode instanceof BFolder) {
                    arrayFolder = (BFolder)childNode;
                    slotsAdded.add((String)entryKey);
                } else {
                    slotParent.add((String)entryKey, (BValue)arrayFolder);
                    slotsAdded.add((String)entryKey);
                }
                GenericPointDecoder.handleJsonArray((BComponent)arrayFolder, config, hConfig, ignoreList, (String)entryKey, element.getAsJsonArray(), slotsAdded, level + 1);
                continue;
            }
            GenericPointDecoder.handleJsonArray(slotParent, config, hConfig, ignoreList, (String)entryKey, element.getAsJsonArray(), slotsAdded, level + 1);
        }
    }

    private static void handleJsonArray(BComponent slotParent, BDeviceConfig config, BDeviceHistory hConfig, List<String> ignoreList, String name, JsonArray array, ArrayList<String> slotsAdded, int level) {
        List<JsonElement> list = array.asList();
        int arrayIndex = 0;
        String prepend = "";
        if (config.getFlattenPayloadStructure()) {
            prepend = name + "_";
        }
        String arrName = "";
        for (JsonElement element : list) {
            BValue childNode;
            arrName = prepend + "Idx" + arrayIndex;
            if (element.isJsonPrimitive()) {
                GenericPointDecoder.addJsonPrimitive(slotParent, config, hConfig, arrName, element.getAsJsonPrimitive(), slotsAdded, level + 1);
                continue;
            }
            if (element.isJsonObject()) {
                if (!config.getFlattenPayloadStructure()) {
                    childNode = slotParent.get(arrName);
                    BFolder objectFolder = new BFolder();
                    if (childNode instanceof BFolder) {
                        objectFolder = (BFolder)childNode;
                    } else {
                        slotParent.add(arrName, (BValue)objectFolder);
                        slotsAdded.add(arrName);
                        slotsAdded.add(arrName);
                    }
                    GenericPointDecoder.handleJsonObject((BComponent)objectFolder, config, hConfig, ignoreList, element.getAsJsonObject(), slotsAdded, level + 1);
                    continue;
                }
                GenericPointDecoder.handleJsonObject(slotParent, config, hConfig, ignoreList, element.getAsJsonObject(), slotsAdded, level + 1);
                continue;
            }
            if (!element.isJsonArray()) continue;
            if (!config.getFlattenPayloadStructure()) {
                childNode = slotParent.get(arrName);
                BFolder arrayFolder = new BFolder();
                if (childNode instanceof BFolder) {
                    arrayFolder = (BFolder)childNode;
                    slotsAdded.add(arrName);
                } else {
                    slotParent.add(arrName, (BValue)arrayFolder);
                    slotsAdded.add(arrName);
                }
                GenericPointDecoder.handleJsonArray((BComponent)arrayFolder, config, hConfig, ignoreList, arrName, element.getAsJsonArray(), slotsAdded, level + 1);
                continue;
            }
            GenericPointDecoder.handleJsonArray(slotParent, config, hConfig, ignoreList, arrName, element.getAsJsonArray(), slotsAdded, level + 1);
        }
    }
}

