/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.decode;

import solutions.onesight.ossChirpManager.decode.OssDigestMaster;
import solutions.onesight.ossChirpManager.decode.PayloadData;
import solutions.onesight.ossChirpManager.decode.PayloadDecoder;

public class DecodeTask
extends Thread {
    private final OssDigestMaster master;
    private final String updateData;
    private final String uniqueId;

    public DecodeTask(OssDigestMaster newMaster, String newUpdateData, String newUniqueId) {
        this.master = newMaster;
        this.updateData = newUpdateData;
        this.uniqueId = newUniqueId;
        this.setName("OSS-ChirpManagerDecodeTask");
    }

    @Override
    public void run() {
        block2: {
            Thread.currentThread().setName("OSS-ChirpManagerDecodeTask-" + this.getId());
            try {
                this.processDeviceJson();
            }
            catch (Exception updateException) {
                this.master.setFault("Update exception: " + updateException);
                if (!this.master.getDebugEnabled()) break block2;
                updateException.printStackTrace();
            }
        }
    }

    private void processDeviceJson() {
        if (this.updateData == null || this.updateData.isEmpty() || this.updateData.equals("-")) {
            return;
        }
        if (!this.master.getEnabled()) {
            return;
        }
        PayloadData payloadData = PayloadDecoder.getPayloadData(this.master, this.updateData, this.uniqueId);
        if (payloadData != null) {
            this.master.processDevice(payloadData);
        }
    }
}

