/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossChirpManager.folder;

import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import solutions.onesight.ossChirpManager.device.BDeviceConfig;
import solutions.onesight.ossChirpManager.device.BOssChirpstackDevice;
import solutions.onesight.ossChirpManager.manager.BDeviceFolder;

@NiagaraType(agent={@AgentOn(types={"ossChirpManager:DeviceFolder"})})
public class BDeviceFolderManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BDeviceFolderManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colStatus = new MgrColumn.Prop(BOssChirpstackDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BOssChirpstackDevice.enabled, 1);
    MgrColumn colDevEui = new DevEuiColumn();
    MgrColumn colDeviceName = new MgrColumn.Prop(BOssChirpstackDevice.deviceName);
    MgrColumn colLastUpdate = new MgrColumn.Prop(BOssChirpstackDevice.lastUpdate);
    MgrColumn colEnableStaleAlarm = new EnableStaleAlarmColumn();
    MgrColumn colStaleAlarmPeriod = new StaleAlarmPeriodColumn();
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colStatus, this.colEnabled, this.colDevEui, this.colDeviceName, this.colLastUpdate, this.colEnableStaleAlarm, this.colStaleAlarmPeriod};

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject obj, Context cxt) {
        super.doLoadValue(obj, cxt);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    static class StaleAlarmPeriodColumn
    extends MgrColumn {
        protected Property[] propList = new Property[]{BDeviceConfig.staleAlarmPeriod};

        public StaleAlarmPeriodColumn() {
            super("Stale Alarm Period", 1);
        }

        public Integer getDeviceValue(Object row) {
            if (row instanceof BOssChirpstackDevice) {
                BOssChirpstackDevice device = (BOssChirpstackDevice)row;
                device.getDeviceConfig().lease();
                return device.getDeviceConfig().getStaleAlarmPeriod();
            }
            return null;
        }

        public Object get(Object row) {
            return this.getDeviceValue(row);
        }

        public BValue load(MgrEditRow row) {
            Integer enableStaleAlarm = this.getDeviceValue(row.getTarget());
            if (enableStaleAlarm != null) {
                return BInteger.make((int)enableStaleAlarm);
            }
            return null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            if (target instanceof BOssChirpstackDevice && value instanceof BInteger) {
                ((BOssChirpstackDevice)target).getDeviceConfig().setStaleAlarmPeriod(((BInteger)value).getInt());
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return StaleAlarmPeriodColumn.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])this.propList);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            StaleAlarmPeriodColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])this.propList);
        }

        public String toDisplayString(Object row, Object value, Context cxt) {
            Integer enableStaleAlarm = this.getDeviceValue(row);
            if (enableStaleAlarm != null) {
                return BRelTime.makeMinutes((int)enableStaleAlarm).toString();
            }
            return null;
        }
    }

    static class EnableStaleAlarmColumn
    extends MgrColumn {
        protected Property[] propList = new Property[]{BDeviceConfig.enableStaleAlarm};

        public EnableStaleAlarmColumn() {
            super("Enable Stale Alarm", 1);
        }

        public Boolean getDeviceValue(Object row) {
            if (row instanceof BOssChirpstackDevice) {
                BOssChirpstackDevice device = (BOssChirpstackDevice)row;
                device.getDeviceConfig().lease();
                return device.getDeviceConfig().getEnableStaleAlarm();
            }
            return null;
        }

        public Object get(Object row) {
            return this.getDeviceValue(row);
        }

        public BValue load(MgrEditRow row) {
            Boolean enableStaleAlarm = this.getDeviceValue(row.getTarget());
            if (enableStaleAlarm != null) {
                return BBoolean.make((boolean)enableStaleAlarm);
            }
            return null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            if (target instanceof BOssChirpstackDevice && value instanceof BBoolean) {
                ((BOssChirpstackDevice)target).getDeviceConfig().setEnableStaleAlarm(((BBoolean)value).getBoolean());
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return EnableStaleAlarmColumn.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])this.propList);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            EnableStaleAlarmColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])this.propList);
        }

        public String toDisplayString(Object row, Object value, Context cxt) {
            Boolean enableStaleAlarm = this.getDeviceValue(row);
            if (enableStaleAlarm != null) {
                return Boolean.toString(enableStaleAlarm);
            }
            return null;
        }
    }

    static class DevEuiColumn
    extends MgrColumn {
        public DevEuiColumn() {
            super("DevEUI");
        }

        public Object get(Object row) {
            return this.getCellContents(row);
        }

        public String toDisplayString(Object row, Object value, Context cxt) {
            return this.getCellContents(row);
        }

        public String getCellContents(Object row) {
            String cellContents = "";
            if (row instanceof BOssChirpstackDevice) {
                cellContents = ((BOssChirpstackDevice)row).getDevEUI();
            }
            return cellContents;
        }
    }

    static class Controller
    extends FolderController {
        Controller(BFolderManager localManager) {
            super(localManager);
            this.newFolder.setFlags(7);
            this.newFolder.setEnabled(true);
            this.edit.setFlags(7);
            this.edit.setEnabled(true);
            this.newCommand.setFlags(0);
            this.newCommand.setEnabled(false);
            this.match.setFlags(0);
            this.match.setEnabled(false);
            this.tagIt.setFlags(0);
            this.tagIt.setEnabled(false);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newFolder, this.edit};
        }

        public CommandArtifact doNew(Context cxt) {
            return null;
        }
    }

    class Model
    extends FolderModel {
        Model(BFolderManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BDeviceFolderManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BOssChirpstackDevice.TYPE, BDeviceFolder.TYPE};
        }

        public Type getFolderType() {
            return BDeviceFolder.TYPE;
        }
    }
}

