/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossBatchFacets.selection.points;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;
import solutions.onesight.ossBatchFacets.selection.points.BPointsDiscoveryEntry;

@NiagaraType
@NiagaraProperty(name="pointPaths", type="BFolder", defaultValue="new BFolder()", flags=7)
public final class BPointsDiscoveryJob
extends BSimpleJob {
    public static final Property pointPaths = BPointsDiscoveryJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE = Sys.loadType(BPointsDiscoveryJob.class);
    private final BOrd stationRootOrd;
    private final BOrd searchRootOrd;
    private String filterString;
    private final boolean filterApplyToSlotName;
    private final boolean filterApplyToDisplayName;
    private final boolean filterApplyToPath;
    private final boolean filterCaseSensitiveFlag;
    private final boolean filterRegexFlag;
    private final int filterPointType;
    private BComponent stationRoot = null;
    private Pattern regexPattern;
    private boolean cancelOperation;

    public BFolder getPointPaths() {
        return (BFolder)this.get(pointPaths);
    }

    public void setPointPaths(BFolder v) {
        this.set(pointPaths, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPointsDiscoveryJob() {
        this.stationRootOrd = null;
        this.searchRootOrd = null;
        this.filterString = null;
        this.filterApplyToSlotName = false;
        this.filterApplyToDisplayName = false;
        this.filterApplyToPath = false;
        this.filterCaseSensitiveFlag = false;
        this.filterRegexFlag = false;
        this.filterPointType = 255;
        this.cancelOperation = false;
    }

    public BPointsDiscoveryJob(BOrd newStationRootOrd, BOrd newSearchRootOrd, String newFilterString, boolean newFilterApplyToSlotName, boolean newFilterApplyToDisplayName, boolean newFilterApplyToPath, boolean newFilterCaseSensitiveFlag, boolean newFilterRegexFlag, int newFilterPointType) {
        this.stationRootOrd = newStationRootOrd;
        this.searchRootOrd = newSearchRootOrd;
        this.filterString = newFilterString;
        this.filterApplyToSlotName = newFilterApplyToSlotName;
        this.filterApplyToDisplayName = newFilterApplyToDisplayName;
        this.filterApplyToPath = newFilterApplyToPath;
        this.filterCaseSensitiveFlag = newFilterCaseSensitiveFlag;
        this.filterRegexFlag = newFilterRegexFlag;
        this.filterPointType = newFilterPointType;
        this.cancelOperation = false;
    }

    public void run(Context cxt) throws Exception {
        this.updateProgress(0);
        this.cancelOperation = false;
        long startTime = System.currentTimeMillis();
        int totalPointCount = 0;
        int pointsFoundCount = 0;
        int pointsIncludedCount = 0;
        if (this.stationRootOrd == null || this.stationRootOrd.toString().isEmpty()) {
            this.log().message("ERROR: Station root is not defined");
            throw new IllegalArgumentException();
        }
        if (this.searchRootOrd == null || this.searchRootOrd.toString().isEmpty()) {
            this.log().message("ERROR: Point search root is not defined");
            throw new IllegalArgumentException();
        }
        String searchRootPath = this.searchRootOrd.relativizeToSession().encodeToString();
        this.log().message("Points search root: " + searchRootPath);
        if (this.filterString != null && this.filterString.isEmpty()) {
            this.filterString = null;
        }
        if (this.filterString == null) {
            this.log().message("No filter");
        } else if (this.filterRegexFlag) {
            if (this.filterCaseSensitiveFlag) {
                this.regexPattern = Pattern.compile(this.filterString);
                this.log().message("Using case sensitive regex filter: " + this.filterString);
            } else {
                this.regexPattern = Pattern.compile(this.filterString, 2);
                this.log().message("Using case insensitive regex filter: " + this.filterString);
            }
        } else if (this.filterCaseSensitiveFlag) {
            this.log().message("Using case sensitive contains filter: " + this.filterString);
        } else {
            this.log().message("Using case insensitive contains filter: " + this.filterString);
            this.filterString = this.filterString.toLowerCase();
        }
        if ((this.filterPointType & 1) != 0) {
            this.log().message("Selected Numeric point type");
        }
        if ((this.filterPointType & 2) != 0) {
            this.log().message("Selected Boolean point type");
        }
        if ((this.filterPointType & 4) != 0) {
            this.log().message("Selected Enum point type");
        }
        if ((this.filterPointType & 8) != 0) {
            this.log().message("Selected String point type");
        }
        this.stationRoot = null;
        try {
            this.updateProgress(1);
            this.log().message("Searching points");
            this.stationRoot = (BComponent)this.stationRootOrd.get();
            this.stationRoot.lease();
            try {
                BObject bObject = this.searchRootOrd.get((BObject)this.stationRoot);
            }
            catch (Exception resolveException) {
                this.stationRoot = null;
            }
        }
        catch (Exception rootException) {
            this.log().message("ERROR: Points discovery root exception: " + rootException);
            throw rootException;
        }
        if (this.stationRoot == null) {
            this.log().message("ERROR: Invalid point search root: " + searchRootPath);
            throw new IllegalArgumentException();
        }
        if (this.cancelOperation) {
            throw new JobCancelException();
        }
        try {
            String pointsBqlQuery = searchRootPath + "|bql:select name, displayName, slotPath, type from control:ControlPoint";
            BITable table = null;
            try {
                table = (BITable)BOrd.make((String)pointsBqlQuery).get((BObject)this.stationRoot);
            }
            catch (SyntaxException querySyntaxException) {
                if (querySyntaxException.getCause() instanceof IOException) {
                    throw new IllegalArgumentException(querySyntaxException.getCause().getMessage());
                }
                throw querySyntaxException;
            }
            if (table instanceof BIRandomAccessTable) {
                totalPointCount = ((BIRandomAccessTable)table).size();
            }
            ColumnList columns = table.getColumns();
            TableCursor cursor = table.cursor();
            while (cursor.next() && !this.cancelOperation) {
                String pointSlotName = cursor.cell(columns.get(0)).toString();
                String pointDisplayName = cursor.cell(columns.get(1)).toString();
                String pointSlotPath = cursor.cell(columns.get(2)).toString();
                if (!pointSlotPath.startsWith("slot:")) continue;
                String pointTypeStr = cursor.cell(columns.get(3)).toString();
                BTypeSpec pointTypeSpec = BTypeSpec.make((String)pointTypeStr);
                if (this.checkType(pointTypeSpec.getResolvedType()) && this.checkFilter(pointSlotName, pointDisplayName, pointSlotPath)) {
                    this.getPointPaths().add("point1?", (BValue)new BPointsDiscoveryEntry(pointSlotName, pointDisplayName, BOrd.make((String)pointSlotPath), pointTypeSpec, this.getExistingFacet(pointSlotPath)));
                    ++pointsIncludedCount;
                }
                ++pointsFoundCount;
                if (totalPointCount <= 0) continue;
                double discoveryProgress = 1.0 + 100.0 * ((double)pointsFoundCount / (double)totalPointCount);
                this.updateProgress((int)discoveryProgress);
                if (pointsFoundCount % 1000 != 0) continue;
                this.log().message("Progress: " + (int)discoveryProgress + " percent ( " + pointsFoundCount + " points )");
            }
            if (this.cancelOperation) {
                throw new JobCancelException();
            }
            long duration = System.currentTimeMillis() - startTime;
            this.log().message("Point search complete");
            this.log().message("Total points found: " + pointsFoundCount);
            this.log().message("Points included: " + pointsIncludedCount);
            this.log().message("Search duration: " + BRelTime.make((long)duration));
        }
        catch (JobCancelException ignore) {
            throw new JobCancelException();
        }
        catch (Exception discoverException) {
            this.log().message("ERROR: Points discovery exception: " + discoverException);
            throw discoverException;
        }
        this.updateProgress(100);
    }

    public boolean checkType(Type currentPointType) {
        if ((this.filterPointType & 1) != 0 && currentPointType.is(BNumericPoint.TYPE)) {
            return true;
        }
        if ((this.filterPointType & 2) != 0 && currentPointType.is(BBooleanPoint.TYPE)) {
            return true;
        }
        if ((this.filterPointType & 4) != 0 && currentPointType.is(BEnumPoint.TYPE)) {
            return true;
        }
        return (this.filterPointType & 8) != 0 && currentPointType.is(BStringPoint.TYPE);
    }

    public boolean checkFilter(String pointSlotName, String pointDisplayName, String pointSlotPath) {
        if (this.filterString == null) {
            return true;
        }
        if (!(this.filterApplyToSlotName || this.filterApplyToDisplayName || this.filterApplyToPath)) {
            return true;
        }
        boolean filterResult = false;
        if (this.filterRegexFlag) {
            if (this.filterApplyToSlotName) {
                filterResult = this.regexPattern.matcher(pointSlotName).find();
            }
            if (this.filterApplyToDisplayName && !filterResult) {
                filterResult = this.regexPattern.matcher(pointDisplayName).find();
            }
            if (this.filterApplyToPath && !filterResult) {
                filterResult = this.regexPattern.matcher(pointSlotPath).find();
            }
        } else if (this.filterCaseSensitiveFlag) {
            if (this.filterApplyToSlotName) {
                filterResult = pointSlotName.contains(this.filterString);
            }
            if (this.filterApplyToDisplayName && !filterResult) {
                filterResult = pointDisplayName.contains(this.filterString);
            }
            if (this.filterApplyToPath && !filterResult) {
                filterResult = pointSlotPath.contains(this.filterString);
            }
        } else {
            if (this.filterApplyToSlotName) {
                filterResult = pointSlotName.toLowerCase().contains(this.filterString);
            }
            if (this.filterApplyToDisplayName && !filterResult) {
                filterResult = pointDisplayName.toLowerCase().contains(this.filterString);
            }
            if (this.filterApplyToPath && !filterResult) {
                filterResult = pointSlotPath.toLowerCase().contains(this.filterString);
            }
        }
        return filterResult;
    }

    public BFacets getExistingFacet(String pointSlotPath) {
        BFacets pointFacets = BFacets.NULL;
        try {
            BObject pointObject = BOrd.make((String)pointSlotPath).get((BObject)this.stationRoot);
            if (pointObject instanceof BControlPoint) {
                BControlPoint controlPoint = (BControlPoint)pointObject;
                controlPoint.lease();
                pointFacets = controlPoint.getFacets();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pointFacets;
    }

    public void updateProgress(int progressPercent) {
        try {
            this.progress(progressPercent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doCancel(Context cxt) {
        this.cancelOperation = true;
    }
}

