/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossBatchFacets.selection.points;

import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossBatchFacets.selection.points.BPointsDiscoveryEntry;

@NiagaraType
@NiagaraProperty(name="updatedPointsCount", type="int", defaultValue="0", flags=7)
public final class BPointFacetAssignmentJob
extends BSimpleJob {
    public static final Property updatedPointsCount = BPointFacetAssignmentJob.newProperty((int)7, (int)0, null);
    public static final Type TYPE = Sys.loadType(BPointFacetAssignmentJob.class);
    private final BOrd stationRootOrd;
    private final BFacets pointFacets;
    private final ArrayList<BPointsDiscoveryEntry> pointsList;
    private boolean cancelOperation;

    public int getUpdatedPointsCount() {
        return this.getInt(updatedPointsCount);
    }

    public void setUpdatedPointsCount(int v) {
        this.setInt(updatedPointsCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPointFacetAssignmentJob() {
        this.stationRootOrd = null;
        this.pointsList = null;
        this.pointFacets = null;
        this.cancelOperation = false;
    }

    public BPointFacetAssignmentJob(BOrd newStationRootOrd, ArrayList<BPointsDiscoveryEntry> newPointsList, BFacets newPointFacets) {
        this.stationRootOrd = newStationRootOrd;
        this.pointsList = newPointsList;
        this.pointFacets = newPointFacets;
        this.cancelOperation = false;
    }

    public void run(Context cxt) throws Exception {
        this.updateProgress(0);
        this.cancelOperation = false;
        long startTime = System.currentTimeMillis();
        if (this.stationRootOrd == null || this.stationRootOrd.toString().isEmpty()) {
            this.log().message("ERROR: Station root is not defined");
            throw new IllegalArgumentException();
        }
        if (this.pointsList == null) {
            this.log().message("ERROR: Invalid points list");
            throw new IllegalArgumentException();
        }
        if (this.pointFacets == null) {
            this.log().message("ERROR: Invalid points facets");
            throw new IllegalArgumentException();
        }
        try {
            int totalPoints = this.pointsList.size();
            int pointCount = 0;
            if (totalPoints < 1) {
                this.log().message("ERROR: Empty points list");
                throw new IllegalArgumentException();
            }
            this.log().message("Selected " + totalPoints + " points");
            this.log().message("Setting point facets");
            this.updateProgress(1);
            BComponent stationRoot = (BComponent)this.stationRootOrd.get();
            stationRoot.lease();
            for (BPointsDiscoveryEntry point : this.pointsList) {
                BObject pointObject = point.getPointSlotPath().get((BObject)stationRoot);
                if (pointObject instanceof BControlPoint) {
                    BControlPoint pointInst = (BControlPoint)pointObject;
                    pointInst.lease();
                    pointInst.setFacets(BFacets.make((BFacets)pointInst.getFacets(), (BFacets)this.pointFacets));
                }
                double discoveryProgress = 1.0 + 99.0 * ((double)(++pointCount) / (double)totalPoints);
                this.updateProgress((int)discoveryProgress);
                if (pointCount % 1000 == 0) {
                    this.log().message("Progress: " + (int)discoveryProgress + " percent ( " + pointCount + " points )");
                }
                if (!this.cancelOperation) continue;
                throw new JobCancelException();
            }
            this.setUpdatedPointsCount(pointCount);
            long duration = System.currentTimeMillis() - startTime;
            this.log().message("Job complete");
            this.log().message("Set facets on " + pointCount + " points");
            this.log().message("Job duration: " + BRelTime.make((long)duration));
        }
        catch (JobCancelException ignore) {
            throw new JobCancelException();
        }
        catch (Exception assignmentException) {
            this.log().message("ERROR: Point facet assignment exception: " + assignmentException);
            throw assignmentException;
        }
        this.updateProgress(100);
    }

    public void updateProgress(int progressPercent) {
        try {
            this.progress(progressPercent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doCancel(Context cxt) {
        this.cancelOperation = true;
    }
}

