/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossBatchFacets.batch;

import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossBatchFacets.license.OssBatchFacetsLicense;
import solutions.onesight.ossBatchFacets.log.OssModuleLog;
import solutions.onesight.ossBatchFacets.selection.points.BBatchParameters;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="batchParameters", type="BBatchParameters", defaultValue="new BBatchParameters()", flags=4)})
public final class BOssBatchFacetEditor
extends BComponent {
    public static final Property status = BOssBatchFacetEditor.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssBatchFacetEditor.newProperty((int)67, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property batchParameters = BOssBatchFacetEditor.newProperty((int)4, (BValue)new BBatchParameters(), null);
    public static final Type TYPE = Sys.loadType(BOssBatchFacetEditor.class);
    private static final Logger log = OssModuleLog.getLog();

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BBatchParameters getBatchParameters() {
        return (BBatchParameters)this.get(batchParameters);
    }

    public void setBatchParameters(BBatchParameters v) {
        this.set(batchParameters, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssBatchFacetsLicense.checkLicense()) {
            this.setFault("ossBatchFacets is not licensed");
            throw new FeatureNotLicensedException("ossBatchFacets is not licensed");
        }
        this.setFaultCause("");
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        log.severe("[" + this.getName() + "] " + faultMessage);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossBatchFacets/icons/oss-icon.png");
    }
}

