/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossBatchFacets.selection.points;

import com.tridium.workbench.fieldeditors.facets.BFacetsEditor;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.BFolder;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import solutions.onesight.ossBatchFacets.batch.BOssBatchFacetEditor;
import solutions.onesight.ossBatchFacets.selection.points.BAssignmentCompleteDialog;
import solutions.onesight.ossBatchFacets.selection.points.BBatchParameters;
import solutions.onesight.ossBatchFacets.selection.points.BPointFacetAssignmentJob;
import solutions.onesight.ossBatchFacets.selection.points.BPointSelection;
import solutions.onesight.ossBatchFacets.selection.points.BPointsDiscoveryEntry;
import solutions.onesight.ossBatchFacets.selection.points.BPointsDiscoveryJob;
import solutions.onesight.ossBatchFacets.selection.points.BPointsFilterDialog;

@NiagaraType(agent={@AgentOn(types={"ossBatchFacets:OssBatchFacetEditor"})})
public class BPointsSelectionManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BPointsSelectionManager.class);

    public Type getType() {
        return TYPE;
    }

    public BBatchParameters getParams() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BOssBatchFacetEditor) {
            return ((BOssBatchFacetEditor)owner).getBatchParameters();
        }
        return null;
    }

    public BComponent getStationRoot() {
        BBatchParameters params = this.getParams();
        if (params != null) {
            return params.getComponentSpace().getRootComponent();
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cxt) {
        BWidget tableContainer;
        super.doLoadValue(obj, cxt);
        BMgrTable modelTable = this.getModel().getTable();
        if (modelTable != null && (tableContainer = modelTable.getParentWidget()) != null) {
            tableContainer.setVisible(false);
            BWidget containerParent = tableContainer.getParentWidget();
            if (containerParent != null) {
                containerParent.setVisible(false);
            }
        }
        this.updateLearnData();
        this.getController().learnMode.setSelected(true);
    }

    public void updateLearnData() {
        BPointsDiscoveryJob learnJob = (BPointsDiscoveryJob)this.getLearn().getJob();
        if (learnJob != null) {
            this.getLearn().updateRoots(learnJob.getPointPaths().getChildren(BPointsDiscoveryEntry.class));
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    class Learn
    extends MgrLearn {
        private final BPointsSelectionManager manager;
        private boolean rerunDiscoveryFlag;

        Learn(BFolderManager localManager) {
            super((BAbstractManager)localManager);
            this.rerunDiscoveryFlag = false;
            this.manager = (BPointsSelectionManager)localManager;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BPointsDiscoveryEntry.pointName), new MgrColumn.Prop(BPointsDiscoveryEntry.pointDisplayName), new MgrColumn.Prop(BPointsDiscoveryEntry.pointSlotPath), new MgrColumn.Prop(BPointsDiscoveryEntry.pointType), new MgrColumn.Prop(BPointsDiscoveryEntry.pointFacets)};
        }

        public void toRow(Object discovery, MgrEditRow row) {
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BPointSelection.TYPE);
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BPointsDiscoveryJob) {
                BPointsSelectionManager.this.updateLearnData();
            } else if (job instanceof BPointFacetAssignmentJob) {
                BPointFacetAssignmentJob facetJob = (BPointFacetAssignmentJob)job;
                if (job.getJobState().getOrdinal() == 4) {
                    BAssignmentCompleteDialog completionDialog = new BAssignmentCompleteDialog(facetJob.getUpdatedPointsCount(), this.rerunDiscoveryFlag);
                    BDialog.open((BWidget)this.manager, (String)"Point Facet Assignment Complete", (Object)((Object)completionDialog), (int)1);
                    this.rerunDiscoveryFlag = completionDialog.getRerunDiscoveryValue();
                    if (this.rerunDiscoveryFlag) {
                        BComponent stationRoot = BPointsSelectionManager.this.getStationRoot();
                        BBatchParameters params = BPointsSelectionManager.this.getParams();
                        BOrd discoveryJobOrd = params.doSubmitPointsDiscoveryJob(stationRoot.getNavOrd());
                        try {
                            BPointsSelectionManager.this.getLearn().setJob(discoveryJobOrd);
                        }
                        catch (Exception exception) {}
                    }
                } else if (job.getJobState().getOrdinal() != 3) {
                    BDialog.error((BWidget)this.manager, (Object)"Facet assignment failed");
                }
            }
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            return false;
        }
    }

    class Controller
    extends FolderController {
        private final MgrController.MgrCommand findPoints;
        private final MgrController.MgrCommand setFacets;
        private final MgrController.MgrCommand selectAll;
        private final BPointsSelectionManager manager;

        Controller(BFolderManager localManager) {
            super(localManager);
            this.manager = (BPointsSelectionManager)localManager;
            this.findPoints = new FindPointsCommand((BWidget)this.manager);
            this.findPoints.setEnabled(true);
            this.findPoints.setFlags(7);
            this.setFacets = new SetFacetsCommand((BWidget)this.manager);
            this.setFacets.setEnabled(true);
            this.setFacets.setFlags(7);
            this.selectAll = new SelectAllCommand((BWidget)this.manager);
            this.selectAll.setEnabled(true);
            this.selectAll.setFlags(7);
            this.newCommand.setEnabled(false);
            this.newCommand.setFlags(0);
            this.add.setEnabled(false);
            this.add.setFlags(0);
            this.match.setEnabled(false);
            this.match.setFlags(0);
            this.tagIt.setEnabled(false);
            this.tagIt.setFlags(0);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.findPoints, this.setFacets, this.selectAll};
        }

        public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
        }

        class SelectAllCommand
        extends MgrController.MgrCommand {
            public SelectAllCommand(BWidget mgr) {
                super(mgr, "Select All");
            }

            public CommandArtifact doInvoke() {
                Controller.this.manager.getLearn().getTable().getSelection().selectAll();
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/selectAll.png")));
            }
        }

        class SetFacetsCommand
        extends MgrController.MgrCommand {
            public SetFacetsCommand(BWidget mgr) {
                super(mgr, "Set Facets");
            }

            public CommandArtifact doInvoke() {
                int selectionCount = Controller.this.manager.getLearn().getTable().getSelection().getRowCount();
                if (selectionCount < 1) {
                    BDialog.error((BWidget)Controller.this.manager, (Object)"No points selected");
                    return null;
                }
                BBatchParameters params = BPointsSelectionManager.this.getParams();
                params.lease();
                BFacets orgFacets = BFacets.NULL;
                int pointType = params.getPointDiscoveryFilterType();
                if (pointType == 1) {
                    orgFacets = params.getNumericFacets();
                } else if (pointType == 2) {
                    orgFacets = params.getBooleanFacets();
                } else if (pointType == 4) {
                    orgFacets = params.getEnumFacets();
                }
                BFacets newFacets = null;
                try {
                    newFacets = BFacetsEditor.open((BWidget)Controller.this.manager, (String)"Set Point Facets", (BFacets)orgFacets, (boolean)false);
                }
                catch (Exception facetException) {
                    BDialog.error((BWidget)Controller.this.manager, (Object)("Facet selection exception: " + facetException));
                    return null;
                }
                if (newFacets == null) {
                    return null;
                }
                if (pointType == 1) {
                    params.setNumericFacets(newFacets);
                } else if (pointType == 2) {
                    params.setBooleanFacets(newFacets);
                } else if (pointType == 4) {
                    params.setEnumFacets(newFacets);
                }
                BOrd stationRootOrd = BPointsSelectionManager.this.getStationRoot().getNavOrd();
                ArrayList<BPointsDiscoveryEntry> selectedList = new ArrayList<BPointsDiscoveryEntry>(selectionCount);
                for (Object selectedObject : Controller.this.manager.getLearn().getTable().getSelectedObjects()) {
                    if (!(selectedObject instanceof BPointsDiscoveryEntry)) continue;
                    selectedList.add((BPointsDiscoveryEntry)selectedObject);
                }
                params.setPointList(selectedList);
                params.setPointFacets(newFacets);
                BOrd facetAssignmentJob = params.doSubmitFacetAssignmentJob(stationRootOrd);
                try {
                    BPointsSelectionManager.this.getLearn().setJob(facetAssignmentJob);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/edit.png")));
            }
        }

        class FindPointsCommand
        extends MgrController.MgrCommand {
            public FindPointsCommand(BWidget mgr) {
                super(mgr, "Find Points");
            }

            public CommandArtifact doInvoke() {
                BComponent stationRoot = BPointsSelectionManager.this.getStationRoot();
                BBatchParameters params = BPointsSelectionManager.this.getParams();
                BPointsFilterDialog filterDialog = new BPointsFilterDialog(stationRoot, params.getPointDiscoveryRoot(), params.getPointDiscoveryFilter(), params.getPointDiscoveryFilterApplyName(), params.getPointDiscoveryFilterApplyPath(), params.getPointDiscoveryFilterCaseSensitive(), params.getPointDiscoveryFilterRegex(), params.getPointDiscoveryFilterType());
                int dialogResult = BDialog.open((BWidget)Controller.this.manager, (String)"Set Point Filter", (Object)((Object)filterDialog), (int)3);
                if (dialogResult == 1) {
                    params.setPointDiscoveryRoot(filterDialog.getRootOrd());
                    params.setPointDiscoveryFilter(filterDialog.getFilterString());
                    params.setPointDiscoveryFilterApplyName(filterDialog.getFilterApplyNameFlag());
                    params.setPointDiscoveryFilterApplyPath(filterDialog.getFilterApplyPathFlag());
                    params.setPointDiscoveryFilterCaseSensitive(filterDialog.getFilterCaseSensitiveFlag());
                    params.setPointDiscoveryFilterRegex(filterDialog.getFilterRegexFlag());
                    params.setPointDiscoveryFilterType(filterDialog.getFilterPointType());
                    BOrd discoveryJobOrd = params.doSubmitPointsDiscoveryJob(stationRoot.getNavOrd());
                    try {
                        BPointsSelectionManager.this.getLearn().setJob(discoveryJobOrd);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/find.png")));
            }
        }
    }

    static class Model
    extends FolderModel {
        Model(BFolderManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[0];
        }

        public Type getFolderType() {
            return BFolder.TYPE;
        }
    }
}

