/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossBatchFacets.selection.points;

import com.tridium.ui.BOptionDialog;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;

@NiagaraType
public final class BPointsFilterDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BPointsFilterDialog.class);
    private BComponent stationRootNode = null;
    private BOrd rootOrd = null;
    private BTextField rootValue = null;
    private BTextField filterText = null;
    private BCheckBox caseValue = null;
    private BCheckBox regexValue = null;
    private BCheckBox applyNameValue = null;
    private BCheckBox applyPathValue = null;
    private final ToggleCommandGroup<ToggleCommand> pointTypeOptGroup = new ToggleCommandGroup();
    private ToggleCommand pointTypeOptNumeric;
    private ToggleCommand pointTypeOptBoolean;
    private ToggleCommand pointTypeOptEnum;
    private ToggleCommand pointTypeOptString;
    private static final int DEFAULT_ROOT_FIELD_SIZE = 50;
    private static final int DEFAULT_FILTER_FIELD_SIZE = 50;

    public Type getType() {
        return TYPE;
    }

    public BPointsFilterDialog() {
    }

    public BPointsFilterDialog(BComponent newStationRootNode, BOrd originalRootOrd, String originalFilterString, boolean originalFilterApplyName, boolean originalFilterApplyPath, boolean originalFilterCaseSensitiveFlag, boolean originalFilterRegexFlag, int originalFilterPointType) {
        this.stationRootNode = newStationRootNode;
        this.rootOrd = originalRootOrd;
        int rootFieldSize = 50;
        String originalRootString = originalRootOrd.encodeToString();
        if (originalRootString.length() > rootFieldSize) {
            rootFieldSize = originalRootString.length();
        }
        this.rootValue = new BTextField(originalRootString, rootFieldSize, false);
        BGridPane rootSelectionPane = new BGridPane(2);
        rootSelectionPane.add(null, (BValue)new BButton((Command)new SelectRootOrd()));
        rootSelectionPane.add(null, (BValue)this.rootValue);
        BBorderPane rootSelectionBorder = new BBorderPane((BWidget)rootSelectionPane, BBorder.solid);
        rootSelectionBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        rootSelectionBorder.setPadding(BInsets.make((double)8.0, (double)11.0, (double)8.0, (double)10.0));
        BLabel filterLabel = new BLabel("Filter: ");
        this.filterText = new BTextField(originalFilterString, 50, true);
        BGridPane filterTextPane = new BGridPane(2);
        filterTextPane.add(null, (BValue)filterLabel);
        filterTextPane.add(null, (BValue)this.filterText);
        BLabel applyNameLabel = new BLabel("Apply to name: ");
        this.applyNameValue = new BCheckBox("", originalFilterApplyName);
        BGridPane applyNamePane = new BGridPane(2);
        applyNamePane.add(null, (BValue)applyNameLabel);
        applyNamePane.add(null, (BValue)this.applyNameValue);
        BLabel applyPathLabel = new BLabel("Apply to slot path: ");
        this.applyPathValue = new BCheckBox("", originalFilterApplyPath);
        BGridPane applyPathPane = new BGridPane(2);
        applyPathPane.add(null, (BValue)applyPathLabel);
        applyPathPane.add(null, (BValue)this.applyPathValue);
        BGridPane filterOptions1Pane = new BGridPane(1);
        filterOptions1Pane.add(null, (BValue)applyNamePane);
        filterOptions1Pane.add(null, (BValue)applyPathPane);
        BLabel caseLabel = new BLabel("Case Sensitive: ");
        this.caseValue = new BCheckBox("", originalFilterCaseSensitiveFlag);
        BGridPane casePane = new BGridPane(2);
        casePane.add(null, (BValue)caseLabel);
        casePane.add(null, (BValue)this.caseValue);
        BLabel regexLabel = new BLabel("Regular Expression: ");
        this.regexValue = new BCheckBox("", originalFilterRegexFlag);
        BGridPane regexPane = new BGridPane(2);
        regexPane.add(null, (BValue)regexLabel);
        regexPane.add(null, (BValue)this.regexValue);
        BGridPane filterOptions2Pane = new BGridPane(1);
        filterOptions2Pane.add(null, (BValue)casePane);
        filterOptions2Pane.add(null, (BValue)regexPane);
        BGridPane filterOptionsPane = new BGridPane(2);
        BBorderPane filterOptions1Border = new BBorderPane((BWidget)filterOptions1Pane, BBorder.none);
        filterOptions1Border.setMargin(BInsets.make((double)3.0, (double)0.0, (double)0.0, (double)60.0));
        filterOptions1Border.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        BBorderPane filterOptions2Border = new BBorderPane((BWidget)filterOptions2Pane, BBorder.none);
        filterOptions2Border.setMargin(BInsets.make((double)3.0, (double)0.0, (double)0.0, (double)20.0));
        filterOptions2Border.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        filterOptionsPane.add(null, (BValue)filterOptions1Border);
        filterOptionsPane.add(null, (BValue)filterOptions2Border);
        BGridPane filterPane = new BGridPane(1);
        filterPane.add(null, (BValue)filterTextPane);
        filterPane.add(null, (BValue)filterOptionsPane);
        BBorderPane filterBorder = new BBorderPane((BWidget)filterPane, BBorder.solid);
        filterBorder.setMargin(BInsets.make((double)2.0, (double)20.0, (double)0.0, (double)20.0));
        filterBorder.setPadding(BInsets.make((double)7.0, (double)13.0, (double)7.0, (double)12.0));
        this.pointTypeOptNumeric = new ToggleCommand((BWidget)this, "Numeric Points");
        this.pointTypeOptBoolean = new ToggleCommand((BWidget)this, "Boolean Points");
        this.pointTypeOptEnum = new ToggleCommand((BWidget)this, "Enum Points");
        this.pointTypeOptString = new ToggleCommand((BWidget)this, "String Points");
        this.pointTypeOptGroup.add(this.pointTypeOptNumeric);
        this.pointTypeOptGroup.add(this.pointTypeOptBoolean);
        this.pointTypeOptGroup.add(this.pointTypeOptEnum);
        this.pointTypeOptGroup.add(this.pointTypeOptString);
        if ((originalFilterPointType & 1) != 0) {
            this.pointTypeOptNumeric.setSelected(true);
        } else {
            this.pointTypeOptNumeric.setSelected(false);
        }
        if ((originalFilterPointType & 2) != 0) {
            this.pointTypeOptBoolean.setSelected(true);
        } else {
            this.pointTypeOptBoolean.setSelected(false);
        }
        if ((originalFilterPointType & 4) != 0) {
            this.pointTypeOptEnum.setSelected(true);
        } else {
            this.pointTypeOptEnum.setSelected(false);
        }
        if ((originalFilterPointType & 8) != 0) {
            this.pointTypeOptString.setSelected(true);
        } else {
            this.pointTypeOptString.setSelected(false);
        }
        BRadioButton pointTypeNumericButton = new BRadioButton(this.pointTypeOptNumeric);
        BRadioButton pointTypeBooleanButton = new BRadioButton(this.pointTypeOptBoolean);
        BRadioButton pointTypeEnumButton = new BRadioButton(this.pointTypeOptEnum);
        BRadioButton pointTypeStringButton = new BRadioButton(this.pointTypeOptString);
        BGridPane pointTypePane = new BGridPane(1);
        pointTypePane.add(null, (BValue)pointTypeNumericButton);
        pointTypePane.add(null, (BValue)pointTypeBooleanButton);
        pointTypePane.add(null, (BValue)pointTypeEnumButton);
        pointTypePane.add(null, (BValue)pointTypeStringButton);
        BBorderPane pointTypeBorder = new BBorderPane((BWidget)pointTypePane, BBorder.solid);
        pointTypeBorder.setMargin(BInsets.make((double)2.0, (double)165.0, (double)0.0, (double)165.0));
        pointTypeBorder.setPadding(BInsets.make((double)5.0, (double)12.0, (double)5.0, (double)14.0));
        BGridPane containerPane = new BGridPane(1);
        containerPane.setValign(BValign.center);
        containerPane.setHalign(BHalign.center);
        containerPane.add(null, (BValue)rootSelectionBorder);
        containerPane.add(null, (BValue)filterBorder);
        containerPane.add(null, (BValue)pointTypeBorder);
        this.setContent((BWidget)containerPane);
    }

    public BOrd getRootOrd() {
        return this.rootOrd;
    }

    public String getFilterString() {
        return this.filterText.getText();
    }

    public boolean getFilterApplyNameFlag() {
        return this.applyNameValue.isSelected();
    }

    public boolean getFilterApplyPathFlag() {
        return this.applyPathValue.isSelected();
    }

    public boolean getFilterCaseSensitiveFlag() {
        return this.caseValue.isSelected();
    }

    public boolean getFilterRegexFlag() {
        return this.regexValue.isSelected();
    }

    public int getFilterPointType() {
        if (this.pointTypeOptNumeric.isSelected()) {
            return 1;
        }
        if (this.pointTypeOptBoolean.isSelected()) {
            return 2;
        }
        if (this.pointTypeOptEnum.isSelected()) {
            return 4;
        }
        if (this.pointTypeOptString.isSelected()) {
            return 8;
        }
        return 0;
    }

    class SelectRootOrd
    extends Command {
        public SelectRootOrd() {
            super((BWidget)BPointsFilterDialog.this, "Set Root");
        }

        public CommandArtifact doInvoke() {
            BNavTree navTree = BPointsFilterDialog.this.stationRootNode != null ? new BNavTree((BINavNode)BPointsFilterDialog.this.stationRootNode) : new BNavTree();
            navTree.setReadonly(true);
            navTree.setController((TreeController)new SelectionController());
            BBorderPane navBorder = new BBorderPane((BWidget)new BTreePane((BTree)navTree), BBorder.solid);
            navBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
            navBorder.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)0.0));
            BConstrainedPane conPane = new BConstrainedPane((BWidget)navBorder);
            conPane.setMinWidth(400.0);
            conPane.setMinHeight(400.0);
            BLabel noteLabel = new BLabel("If there is no selection then all points will be searched");
            BBorderPane labelBorder = new BBorderPane((BWidget)conPane, noteLabel, BBorder.none);
            labelBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
            labelBorder.setPadding(BInsets.make((double)12.0, (double)2.0, (double)0.0, (double)2.0));
            int button = BDialog.open((BWidget)BPointsFilterDialog.this, (String)"Choose Search Root", (Object)labelBorder, (int)3);
            if (button == 1) {
                Object nodeObj;
                BComponent searchNode = null;
                NavTreeNode node = (NavTreeNode)navTree.getSelection().getNode();
                if (node != null && (nodeObj = node.getSubject()) instanceof BComponent) {
                    searchNode = (BComponent)nodeObj;
                }
                if (searchNode != null) {
                    BPointsFilterDialog.this.rootOrd = searchNode.getNavOrd().relativizeToSession();
                } else {
                    BPointsFilterDialog.this.rootOrd = BOrd.make((String)"station:|slot:/");
                }
                BPointsFilterDialog.this.rootValue.setText(BPointsFilterDialog.this.rootOrd.encodeToString());
                BPointsFilterDialog.this.rootValue.setVisibleColumns(BPointsFilterDialog.this.rootOrd.encodeToString().length());
            }
            return null;
        }

        class SelectionController
        extends TreeController {
            SelectionController() {
            }

            protected void doSelectAction(TreeNode target, double x, double y) {
                BOptionDialog dlg = (BOptionDialog)this.getTree().getShell();
                dlg.getOkButton().invokeAction();
            }
        }
    }
}

